package physx.physics;

public enum PxArticulationDriveTypeEnum {

    /**
     * The output of the implicit spring drive controller is a force/torque.
     */
    eFORCE(geteFORCE()),
    /**
     * The output of the implicit spring drive controller is a joint acceleration (use this to get (spatial)-inertia-invariant behavior of the drive).
     */
    eACCELERATION(geteACCELERATION()),
    /**
     * Sets the drive gains internally to track a target position almost kinematically (i.e. with very high drive gains).
     */
    eTARGET(geteTARGET()),
    /**
     * Sets the drive gains internally to track a target velocity almost kinematically (i.e. with very high drive gains).
     */
    eVELOCITY(geteVELOCITY()),
    eNONE(geteNONE());
    public final int value;
    
    PxArticulationDriveTypeEnum(int value) {
        this.value = value;
    }

    private static native int _geteFORCE();
    private static int geteFORCE() {
        de.fabmax.physxjni.Loader.load();
        return _geteFORCE();
    }

    private static native int _geteACCELERATION();
    private static int geteACCELERATION() {
        de.fabmax.physxjni.Loader.load();
        return _geteACCELERATION();
    }

    private static native int _geteTARGET();
    private static int geteTARGET() {
        de.fabmax.physxjni.Loader.load();
        return _geteTARGET();
    }

    private static native int _geteVELOCITY();
    private static int geteVELOCITY() {
        de.fabmax.physxjni.Loader.load();
        return _geteVELOCITY();
    }

    private static native int _geteNONE();
    private static int geteNONE() {
        de.fabmax.physxjni.Loader.load();
        return _geteNONE();
    }

    public static PxArticulationDriveTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationDriveTypeEnum: " + value);
    }

}
