package physx.physics;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.common.PxVec3;

/**
 * Data structure used to access the root link state and acceleration.
 * @see PxArticulationCache
 */
public class PxArticulationRootLinkData extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationRootLinkData wrapPointer(long address) {
        return address != 0L ? new PxArticulationRootLinkData(address) : null;
    }
    
    public static PxArticulationRootLinkData arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationRootLinkData(long address) {
        super(address);
    }

    // Constructors

    public PxArticulationRootLinkData() {
        address = _PxArticulationRootLinkData();
    }
    private static native long _PxArticulationRootLinkData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * Actor transform
     */
    public PxTransform getTransform() {
        checkNotNull();
        return PxTransform.wrapPointer(_getTransform(address));
    }
    private static native long _getTransform(long address);

    /**
     * Actor transform
     */
    public void setTransform(PxTransform value) {
        checkNotNull();
        _setTransform(address, value.getAddress());
    }
    private static native void _setTransform(long address, long value);

    /**
     * Link linear velocity
     */
    public PxVec3 getWorldLinVel() {
        checkNotNull();
        return PxVec3.wrapPointer(_getWorldLinVel(address));
    }
    private static native long _getWorldLinVel(long address);

    /**
     * Link linear velocity
     */
    public void setWorldLinVel(PxVec3 value) {
        checkNotNull();
        _setWorldLinVel(address, value.getAddress());
    }
    private static native void _setWorldLinVel(long address, long value);

    /**
     * Link angular velocity
     */
    public PxVec3 getWorldAngVel() {
        checkNotNull();
        return PxVec3.wrapPointer(_getWorldAngVel(address));
    }
    private static native long _getWorldAngVel(long address);

    /**
     * Link angular velocity
     */
    public void setWorldAngVel(PxVec3 value) {
        checkNotNull();
        _setWorldAngVel(address, value.getAddress());
    }
    private static native void _setWorldAngVel(long address, long value);

    /**
     * Link classical linear acceleration
     */
    public PxVec3 getWorldLinAccel() {
        checkNotNull();
        return PxVec3.wrapPointer(_getWorldLinAccel(address));
    }
    private static native long _getWorldLinAccel(long address);

    /**
     * Link classical linear acceleration
     */
    public void setWorldLinAccel(PxVec3 value) {
        checkNotNull();
        _setWorldLinAccel(address, value.getAddress());
    }
    private static native void _setWorldLinAccel(long address, long value);

    /**
     * Link angular acceleration
     */
    public PxVec3 getWorldAngAccel() {
        checkNotNull();
        return PxVec3.wrapPointer(_getWorldAngAccel(address));
    }
    private static native long _getWorldAngAccel(long address);

    /**
     * Link angular acceleration
     */
    public void setWorldAngAccel(PxVec3 value) {
        checkNotNull();
        _setWorldAngAccel(address, value.getAddress());
    }
    private static native void _setWorldAngAccel(long address, long value);

}
