package physx.support;

import physx.NativeObject;
import physx.character.PxController;
import physx.character.PxControllerObstacleHit;
import physx.character.PxControllerShapeHit;
import physx.character.PxControllersHit;
import physx.character.PxObstacle;
import physx.common.PxBounds3;
import physx.common.PxVec3;
import physx.physics.PxActor;
import physx.physics.PxContactPair;
import physx.physics.PxContactPairHeader;
import physx.physics.PxShape;
import physx.physics.PxTriggerPair;

public class NativeArrayHelpers extends NativeObject {

    protected NativeArrayHelpers() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static NativeArrayHelpers wrapPointer(long address) {
        return address != 0L ? new NativeArrayHelpers(address) : null;
    }
    
    public static NativeArrayHelpers arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected NativeArrayHelpers(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param base  WebIDL type: {@link PxU8ConstPtr} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: octet
     */
    public static byte getU8At(PxU8ConstPtr base, int index) {
        return _getU8At(base.getAddress(), index);
    }
    private static native byte _getU8At(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxU16ConstPtr} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: unsigned short
     */
    public static short getU16At(PxU16ConstPtr base, int index) {
        return _getU16At(base.getAddress(), index);
    }
    private static native short _getU16At(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxU32ConstPtr} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: unsigned long
     */
    public static int getU32At(PxU32ConstPtr base, int index) {
        return _getU32At(base.getAddress(), index);
    }
    private static native int _getU32At(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxRealPtr} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: float
     */
    public static float getRealAt(PxRealPtr base, int index) {
        return _getRealAt(base.getAddress(), index);
    }
    private static native float _getRealAt(long base, int index);

    /**
     * @param voidPtr WebIDL type: VoidPtr
     * @return WebIDL type: {@link PxU8Ptr} [Value]
     */
    public static PxU8Ptr voidToU8Ptr(NativeObject voidPtr) {
        return PxU8Ptr.wrapPointer(_voidToU8Ptr(voidPtr.getAddress()));
    }
    private static native long _voidToU8Ptr(long voidPtr);

    /**
     * @param voidPtr WebIDL type: VoidPtr
     * @return WebIDL type: {@link PxU16Ptr} [Value]
     */
    public static PxU16Ptr voidToU16Ptr(NativeObject voidPtr) {
        return PxU16Ptr.wrapPointer(_voidToU16Ptr(voidPtr.getAddress()));
    }
    private static native long _voidToU16Ptr(long voidPtr);

    /**
     * @param voidPtr WebIDL type: VoidPtr
     * @return WebIDL type: {@link PxU32Ptr} [Value]
     */
    public static PxU32Ptr voidToU32Ptr(NativeObject voidPtr) {
        return PxU32Ptr.wrapPointer(_voidToU32Ptr(voidPtr.getAddress()));
    }
    private static native long _voidToU32Ptr(long voidPtr);

    /**
     * @param voidPtr WebIDL type: VoidPtr
     * @return WebIDL type: {@link PxRealPtr} [Value]
     */
    public static PxRealPtr voidToRealPtr(NativeObject voidPtr) {
        return PxRealPtr.wrapPointer(_voidToRealPtr(voidPtr.getAddress()));
    }
    private static native long _voidToRealPtr(long voidPtr);

    /**
     * @param base  WebIDL type: {@link PxActor}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxActor}
     */
    public static PxActor getActorAt(PxActor base, int index) {
        return PxActor.wrapPointer(_getActorAt(base.getAddress(), index));
    }
    private static native long _getActorAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxBounds3}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxBounds3}
     */
    public static PxBounds3 getBounds3At(PxBounds3 base, int index) {
        return PxBounds3.wrapPointer(_getBounds3At(base.getAddress(), index));
    }
    private static native long _getBounds3At(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxContactPair}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxContactPair}
     */
    public static PxContactPair getContactPairAt(PxContactPair base, int index) {
        return PxContactPair.wrapPointer(_getContactPairAt(base.getAddress(), index));
    }
    private static native long _getContactPairAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxContactPairHeader}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxContactPairHeader}
     */
    public static PxContactPairHeader getContactPairHeaderAt(PxContactPairHeader base, int index) {
        return PxContactPairHeader.wrapPointer(_getContactPairHeaderAt(base.getAddress(), index));
    }
    private static native long _getContactPairHeaderAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxController}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxController}
     */
    public static PxController getControllerAt(PxController base, int index) {
        return PxController.wrapPointer(_getControllerAt(base.getAddress(), index));
    }
    private static native long _getControllerAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxControllerShapeHit}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxControllerShapeHit}
     */
    public static PxControllerShapeHit getControllerShapeHitAt(PxControllerShapeHit base, int index) {
        return PxControllerShapeHit.wrapPointer(_getControllerShapeHitAt(base.getAddress(), index));
    }
    private static native long _getControllerShapeHitAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxControllersHit}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxControllersHit}
     */
    public static PxControllersHit getControllersHitAt(PxControllersHit base, int index) {
        return PxControllersHit.wrapPointer(_getControllersHitAt(base.getAddress(), index));
    }
    private static native long _getControllersHitAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxControllerObstacleHit}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxControllerObstacleHit}
     */
    public static PxControllerObstacleHit getControllerObstacleHitAt(PxControllerObstacleHit base, int index) {
        return PxControllerObstacleHit.wrapPointer(_getControllerObstacleHitAt(base.getAddress(), index));
    }
    private static native long _getControllerObstacleHitAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxObstacle}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxObstacle}
     */
    public static PxObstacle getObstacleAt(PxObstacle base, int index) {
        return PxObstacle.wrapPointer(_getObstacleAt(base.getAddress(), index));
    }
    private static native long _getObstacleAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxShape}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxShape}
     */
    public static PxShape getShapeAt(PxShape base, int index) {
        return PxShape.wrapPointer(_getShapeAt(base.getAddress(), index));
    }
    private static native long _getShapeAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxTriggerPair}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxTriggerPair}
     */
    public static PxTriggerPair getTriggerPairAt(PxTriggerPair base, int index) {
        return PxTriggerPair.wrapPointer(_getTriggerPairAt(base.getAddress(), index));
    }
    private static native long _getTriggerPairAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxVec3}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxVec3}
     */
    public static PxVec3 getVec3At(PxVec3 base, int index) {
        return PxVec3.wrapPointer(_getVec3At(base.getAddress(), index));
    }
    private static native long _getVec3At(long base, int index);

}
