package physx.vehicle2;

import physx.NativeObject;
import physx.cooking.PxCookingParams;
import physx.physics.PxMaterial;
import physx.physics.PxPhysics;

public class PhysXIntegrationState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PhysXIntegrationState wrapPointer(long address) {
        return address != 0L ? new PhysXIntegrationState(address) : null;
    }
    
    public static PhysXIntegrationState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PhysXIntegrationState(long address) {
        super(address);
    }

    // Constructors

    public PhysXIntegrationState() {
        address = _PhysXIntegrationState();
    }
    private static native long _PhysXIntegrationState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehiclePhysXActor} [Value]
     */
    public PxVehiclePhysXActor getPhysxActor() {
        checkNotNull();
        return PxVehiclePhysXActor.wrapPointer(_getPhysxActor(address));
    }
    private static native long _getPhysxActor(long address);

    /**
     * @param value WebIDL type: {@link PxVehiclePhysXActor} [Value]
     */
    public void setPhysxActor(PxVehiclePhysXActor value) {
        checkNotNull();
        _setPhysxActor(address, value.getAddress());
    }
    private static native void _setPhysxActor(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehiclePhysXSteerState} [Value]
     */
    public PxVehiclePhysXSteerState getPhysxSteerState() {
        checkNotNull();
        return PxVehiclePhysXSteerState.wrapPointer(_getPhysxSteerState(address));
    }
    private static native long _getPhysxSteerState(long address);

    /**
     * @param value WebIDL type: {@link PxVehiclePhysXSteerState} [Value]
     */
    public void setPhysxSteerState(PxVehiclePhysXSteerState value) {
        checkNotNull();
        _setPhysxSteerState(address, value.getAddress());
    }
    private static native void _setPhysxSteerState(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehiclePhysXConstraints} [Value]
     */
    public PxVehiclePhysXConstraints getPhysxConstraints() {
        checkNotNull();
        return PxVehiclePhysXConstraints.wrapPointer(_getPhysxConstraints(address));
    }
    private static native long _getPhysxConstraints(long address);

    /**
     * @param value WebIDL type: {@link PxVehiclePhysXConstraints} [Value]
     */
    public void setPhysxConstraints(PxVehiclePhysXConstraints value) {
        checkNotNull();
        _setPhysxConstraints(address, value.getAddress());
    }
    private static native void _setPhysxConstraints(long address, long value);

    // Functions

    public void destroyState() {
        checkNotNull();
        _destroyState(address);
    }
    private static native void _destroyState(long address);

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @param baseParams      WebIDL type: {@link BaseVehicleParams} [Const, Ref]
     * @param physxParams     WebIDL type: {@link PhysXIntegrationParams} [Const, Ref]
     * @param physics         WebIDL type: {@link PxPhysics} [Ref]
     * @param params          WebIDL type: {@link PxCookingParams} [Const, Ref]
     * @param defaultMaterial WebIDL type: {@link PxMaterial} [Ref]
     */
    public void create(BaseVehicleParams baseParams, PhysXIntegrationParams physxParams, PxPhysics physics, PxCookingParams params, PxMaterial defaultMaterial) {
        checkNotNull();
        _create(address, baseParams.getAddress(), physxParams.getAddress(), physics.getAddress(), params.getAddress(), defaultMaterial.getAddress());
    }
    private static native void _create(long address, long baseParams, long physxParams, long physics, long params, long defaultMaterial);

}
