package physx.vehicle2;

import physx.geometry.PxConvexMesh;
import physx.physics.PxScene;

public class PxVehiclePhysXSimulationContext extends PxVehicleSimulationContext {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehiclePhysXSimulationContext wrapPointer(long address) {
        return address != 0L ? new PxVehiclePhysXSimulationContext(address) : null;
    }
    
    public static PxVehiclePhysXSimulationContext arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehiclePhysXSimulationContext(long address) {
        super(address);
    }

    // Constructors

    public PxVehiclePhysXSimulationContext() {
        address = _PxVehiclePhysXSimulationContext();
    }
    private static native long _PxVehiclePhysXSimulationContext();

    // Attributes

    /**
     */
    public PxConvexMesh getPhysxUnitCylinderSweepMesh() {
        checkNotNull();
        return PxConvexMesh.wrapPointer(_getPhysxUnitCylinderSweepMesh(address));
    }
    private static native long _getPhysxUnitCylinderSweepMesh(long address);

    /**
     */
    public void setPhysxUnitCylinderSweepMesh(PxConvexMesh value) {
        checkNotNull();
        _setPhysxUnitCylinderSweepMesh(address, value.getAddress());
    }
    private static native void _setPhysxUnitCylinderSweepMesh(long address, long value);

    /**
     */
    public PxScene getPhysxScene() {
        checkNotNull();
        return PxScene.wrapPointer(_getPhysxScene(address));
    }
    private static native long _getPhysxScene(long address);

    /**
     */
    public void setPhysxScene(PxScene value) {
        checkNotNull();
        _setPhysxScene(address, value.getAddress());
    }
    private static native void _setPhysxScene(long address, long value);

    /**
     */
    public PxVehiclePhysXActorUpdateModeEnum getPhysxActorUpdateMode() {
        checkNotNull();
        return PxVehiclePhysXActorUpdateModeEnum.forValue(_getPhysxActorUpdateMode(address));
    }
    private static native int _getPhysxActorUpdateMode(long address);

    /**
     */
    public void setPhysxActorUpdateMode(PxVehiclePhysXActorUpdateModeEnum value) {
        checkNotNull();
        _setPhysxActorUpdateMode(address, value.value);
    }
    private static native void _setPhysxActorUpdateMode(long address, int value);

    /**
     * Wake counter value to set on the physx actor if a reset is required.
     * <p>
     * Certain vehicle states should keep a physx actor of a vehicle awake. This
     * will be achieved by resetting the wake counter value if needed. The wake
     * counter value is the minimum simulation time that a physx actor will stay
     * awake.
     * <p>
     * <b>Unit:</b> time
     */
    public float getPhysxActorWakeCounterResetValue() {
        checkNotNull();
        return _getPhysxActorWakeCounterResetValue(address);
    }
    private static native float _getPhysxActorWakeCounterResetValue(long address);

    /**
     * Wake counter value to set on the physx actor if a reset is required.
     * <p>
     * Certain vehicle states should keep a physx actor of a vehicle awake. This
     * will be achieved by resetting the wake counter value if needed. The wake
     * counter value is the minimum simulation time that a physx actor will stay
     * awake.
     * <p>
     * <b>Unit:</b> time
     */
    public void setPhysxActorWakeCounterResetValue(float value) {
        checkNotNull();
        _setPhysxActorWakeCounterResetValue(address, value);
    }
    private static native void _setPhysxActorWakeCounterResetValue(long address, float value);

    /**
     * Threshold below which to check whether the physx actor wake counter
     *        should get reset.
     * <p>
     * <b>Unit:</b> time
     */
    public float getPhysxActorWakeCounterThreshold() {
        checkNotNull();
        return _getPhysxActorWakeCounterThreshold(address);
    }
    private static native float _getPhysxActorWakeCounterThreshold(long address);

    /**
     * Threshold below which to check whether the physx actor wake counter
     *        should get reset.
     * <p>
     * <b>Unit:</b> time
     */
    public void setPhysxActorWakeCounterThreshold(float value) {
        checkNotNull();
        _setPhysxActorWakeCounterThreshold(address, value);
    }
    private static native void _setPhysxActorWakeCounterThreshold(long address, float value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehiclePhysXSimulationContext} [Value]
     */
    public PxVehiclePhysXSimulationContext transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehiclePhysXSimulationContext.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

}
