package physx.vehicle2;

import physx.support.PxU32ConstPtr;

/**
 * A description of a tank differential.
 * <b>Note:</b> The wheels on a tank may be connected to the differential or not connected to the differential.
 * <b>Note:</b> The wheels on a tank track may be connected to a tank track or not connected to a tank track.
 * <b>Note:</b> Wheels connected to the differential but not to a tank track receive the torque split specified by the
 * corresponding elements of PxVehicleMultiWheelDriveDifferentialParams::torqueRatios[].
 * <b>Note:</b> Wheels connected to a tank track but not to the differential receive no torque from the engine.
 * <b>Note:</b> Wheels connected to a tank track and to the differential receive the torque split specified by the 
 * corresponding elements of PxVehicleMultiWheelDriveDifferentialParams::torqueRatios[] multiplied by the corresponding
 * thrust controller value. If the thrust controller has a negative value, the wheels will receive a torque that is negative
 * with respect to the gearing ratio.
 * <b>Note:</b> The wheels in each tank track have a constraint applied to them to enforce the rule that they all have the same longitudinal speed
 * at the contact point between the wheel and the tank track.
 */
public class PxVehicleTankDriveDifferentialParams extends PxVehicleMultiWheelDriveDifferentialParams {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTankDriveDifferentialParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleTankDriveDifferentialParams(address) : null;
    }
    
    public static PxVehicleTankDriveDifferentialParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTankDriveDifferentialParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleTankDriveDifferentialParams
     */
    public static PxVehicleTankDriveDifferentialParams createAt(long address) {
        __placement_new_PxVehicleTankDriveDifferentialParams(address);
        PxVehicleTankDriveDifferentialParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleTankDriveDifferentialParams
     */
    public static <T> PxVehicleTankDriveDifferentialParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleTankDriveDifferentialParams(address);
        PxVehicleTankDriveDifferentialParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleTankDriveDifferentialParams(long address);

    // Constructors

    public PxVehicleTankDriveDifferentialParams() {
        address = _PxVehicleTankDriveDifferentialParams();
    }
    private static native long _PxVehicleTankDriveDifferentialParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The number of tracks
     */
    public int getNbTracks() {
        checkNotNull();
        return _getNbTracks(address);
    }
    private static native int _getNbTracks(long address);

    /**
     * The number of tracks
     */
    public void setNbTracks(int value) {
        checkNotNull();
        _setNbTracks(address, value);
    }
    private static native void _setNbTracks(long address, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getThrustIdPerTrack(int index) {
        checkNotNull();
        return _getThrustIdPerTrack(address, index);
    }
    private static native int _getThrustIdPerTrack(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setThrustIdPerTrack(int index, int value) {
        checkNotNull();
        _setThrustIdPerTrack(address, index, value);
    }
    private static native void _setThrustIdPerTrack(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelsPerTrack(int index) {
        checkNotNull();
        return _getNbWheelsPerTrack(address, index);
    }
    private static native int _getNbWheelsPerTrack(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setNbWheelsPerTrack(int index, int value) {
        checkNotNull();
        _setNbWheelsPerTrack(address, index, value);
    }
    private static native void _setNbWheelsPerTrack(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getTrackToWheelIds(int index) {
        checkNotNull();
        return _getTrackToWheelIds(address, index);
    }
    private static native int _getTrackToWheelIds(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setTrackToWheelIds(int index, int value) {
        checkNotNull();
        _setTrackToWheelIds(address, index, value);
    }
    private static native void _setTrackToWheelIds(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getWheelIdsInTrackOrder(int index) {
        checkNotNull();
        return _getWheelIdsInTrackOrder(address, index);
    }
    private static native int _getWheelIdsInTrackOrder(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setWheelIdsInTrackOrder(int index, int value) {
        checkNotNull();
        _setWheelIdsInTrackOrder(address, index, value);
    }
    private static native void _setWheelIdsInTrackOrder(long address, int index, int value);

    /**
     * The number of wheels in all tracks.
     */
    public int getNbWheelsInTracks() {
        checkNotNull();
        return _getNbWheelsInTracks(address);
    }
    private static native int _getNbWheelsInTracks(long address);

    /**
     * The number of wheels in all tracks.
     */
    public void setNbWheelsInTracks(int value) {
        checkNotNull();
        _setNbWheelsInTracks(address, value);
    }
    private static native void _setNbWheelsInTracks(long address, int value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * Return the number of wheels in the ith track.
     * @param i specifies the track to be queried for its wheel count.
     * @return The number of wheels in the specified track.
     * @see #getWheelInTrack
     */
    public int getNbWheelsInTrack(int i) {
        checkNotNull();
        return _getNbWheelsInTrack(address, i);
    }
    private static native int _getNbWheelsInTrack(long address, int i);

    /**
     * Return the array of all wheels in the ith track.
     * @param i specifies the track to be queried for its wheels.
     * @return The array of wheels in the specified track.
     */
    public PxU32ConstPtr getWheelsInTrack(int i) {
        checkNotNull();
        return PxU32ConstPtr.wrapPointer(_getWheelsInTrack(address, i));
    }
    private static native long _getWheelsInTrack(long address, int i);

    /**
     * Return the wheel id of the jth wheel in the ith track.
     * @param j specifies that the wheel id to be returned is the jth wheel in the list of wheels on the specified track.
     * @param i specifies the track to be queried.
     * @return The wheel id of the jth wheel in the ith track.
     * @see #getNbWheelsInTrack
     */
    public int getWheelInTrack(int j, int i) {
        checkNotNull();
        return _getWheelInTrack(address, j, i);
    }
    private static native int _getWheelInTrack(long address, int j, int i);

    /**
     * Return the index of the thrust controller that will control a specified track.
     * @param i specifies the track to be queried for its thrust controller index
     * @return The index of the thrust controller that will control the ith track.
     */
    public int getThrustControllerIndex(int i) {
        checkNotNull();
        return _getThrustControllerIndex(address, i);
    }
    private static native int _getThrustControllerIndex(long address, int i);

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleTankDriveDifferentialParams} [Value]
     */
    public PxVehicleTankDriveDifferentialParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleTankDriveDifferentialParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

}
