/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.physxjni;

import de.fabmax.physxjni.Loader;
import de.fabmax.physxjni.NativeMeta;

public enum Platform {
    LINUX("de.fabmax.physxjni.NativeMetaLinux"),
    WINDOWS("de.fabmax.physxjni.NativeMetaWindows"),
    MACOS("de.fabmax.physxjni.NativeMetaMacos"),
    MACOS_ARM64("de.fabmax.physxjni.NativeMetaMacosArm64");

    private final String metaClassName;

    private Platform(String metaClassName) {
        this.metaClassName = metaClassName;
    }

    public NativeMeta getMeta() throws ReflectiveOperationException {
        Class<?> metaClass = Loader.class.getClassLoader().loadClass(this.metaClassName);
        return (NativeMeta)metaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static Platform getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch");
        if (osName.contains("windows")) {
            return WINDOWS;
        }
        if (osName.contains("linux")) {
            return LINUX;
        }
        if (osName.contains("mac os x") || osName.contains("darwin") || osName.contains("osx")) {
            if (arch != null && arch.equals("aarch64")) {
                return MACOS_ARM64;
            }
            return MACOS;
        }
        throw new IllegalStateException("Unsupported OS: " + osName);
    }
}

