package physx.character;


public class PxControllerFilterCallbackImpl extends PxControllerFilterCallback {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxControllerFilterCallbackImpl wrapPointer(long address) {
        return address != 0L ? new PxControllerFilterCallbackImpl(address) : null;
    }
    
    public static PxControllerFilterCallbackImpl arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxControllerFilterCallbackImpl(long address) {
        super(address);
    }

    protected PxControllerFilterCallbackImpl() {
        address = _PxControllerFilterCallbackImpl();
    }
    private native long _PxControllerFilterCallbackImpl();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private boolean _filter(long a, long b) {
        return filter(PxController.wrapPointer(a), PxController.wrapPointer(b));
    }

    /**
     * @param a WebIDL type: {@link PxController} [Const, Ref]
     * @param b WebIDL type: {@link PxController} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean filter(PxController a, PxController b) {
        return false;
    }

}
