package physx.common;

import physx.NativeObject;
import physx.particles.PxParticleAndDiffuseBuffer;
import physx.particles.PxParticleAndDiffuseBufferDesc;
import physx.particles.PxParticleBufferDesc;
import physx.particles.PxParticleClothBuffer;
import physx.particles.PxParticleClothBufferHelper;
import physx.particles.PxParticleClothCooker;
import physx.particles.PxParticleClothDesc;
import physx.particles.PxParticleClothPreProcessor;
import physx.particles.PxPartitionedParticleCloth;
import physx.support.PxU32Ptr;

public class PxCudaTopLevelFunctions extends NativeObject {

    protected PxCudaTopLevelFunctions() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCudaTopLevelFunctions wrapPointer(long address) {
        return address != 0L ? new PxCudaTopLevelFunctions(address) : null;
    }
    
    public static PxCudaTopLevelFunctions arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCudaTopLevelFunctions(long address) {
        super(address);
    }

    // Functions

    /**
     * @param foundation WebIDL type: {@link PxFoundation} [Ref]
     * @return WebIDL type: long
     */
    public static int GetSuggestedCudaDeviceOrdinal(PxFoundation foundation) {
        return _GetSuggestedCudaDeviceOrdinal(foundation.getAddress());
    }
    private static native int _GetSuggestedCudaDeviceOrdinal(long foundation);

    /**
     * @param foundation WebIDL type: {@link PxFoundation} [Ref]
     * @param desc       WebIDL type: {@link PxCudaContextManagerDesc} [Const, Ref]
     * @return WebIDL type: {@link PxCudaContextManager}
     */
    public static PxCudaContextManager CreateCudaContextManager(PxFoundation foundation, PxCudaContextManagerDesc desc) {
        return PxCudaContextManager.wrapPointer(_CreateCudaContextManager(foundation.getAddress(), desc.getAddress()));
    }
    private static native long _CreateCudaContextManager(long foundation, long desc);

    /**
     * @param cudaContextManager WebIDL type: {@link PxCudaContextManager}
     * @return WebIDL type: {@link PxParticleClothPreProcessor}
     */
    public static PxParticleClothPreProcessor CreateParticleClothPreProcessor(PxCudaContextManager cudaContextManager) {
        return PxParticleClothPreProcessor.wrapPointer(_CreateParticleClothPreProcessor(cudaContextManager.getAddress()));
    }
    private static native long _CreateParticleClothPreProcessor(long cudaContextManager);

    /**
     * @param maxCloths          WebIDL type: unsigned long
     * @param maxTriangles       WebIDL type: unsigned long
     * @param maxSprings         WebIDL type: unsigned long
     * @param maxParticles       WebIDL type: unsigned long
     * @param cudaContextManager WebIDL type: {@link PxCudaContextManager}
     * @return WebIDL type: {@link PxParticleClothBufferHelper}
     */
    public static PxParticleClothBufferHelper CreateParticleClothBufferHelper(int maxCloths, int maxTriangles, int maxSprings, int maxParticles, PxCudaContextManager cudaContextManager) {
        return PxParticleClothBufferHelper.wrapPointer(_CreateParticleClothBufferHelper(maxCloths, maxTriangles, maxSprings, maxParticles, cudaContextManager.getAddress()));
    }
    private static native long _CreateParticleClothBufferHelper(int maxCloths, int maxTriangles, int maxSprings, int maxParticles, long cudaContextManager);

    /**
     * @param desc               WebIDL type: {@link PxParticleBufferDesc} [Const, Ref]
     * @param clothDesc          WebIDL type: {@link PxParticleClothDesc} [Const, Ref]
     * @param output             WebIDL type: {@link PxPartitionedParticleCloth} [Ref]
     * @param cudaContextManager WebIDL type: {@link PxCudaContextManager}
     * @return WebIDL type: {@link PxParticleClothBuffer}
     */
    public static PxParticleClothBuffer CreateAndPopulateParticleClothBuffer(PxParticleBufferDesc desc, PxParticleClothDesc clothDesc, PxPartitionedParticleCloth output, PxCudaContextManager cudaContextManager) {
        return PxParticleClothBuffer.wrapPointer(_CreateAndPopulateParticleClothBuffer(desc.getAddress(), clothDesc.getAddress(), output.getAddress(), cudaContextManager.getAddress()));
    }
    private static native long _CreateAndPopulateParticleClothBuffer(long desc, long clothDesc, long output, long cudaContextManager);

    /**
     * @param desc               WebIDL type: {@link PxParticleAndDiffuseBufferDesc} [Const, Ref]
     * @param cudaContextManager WebIDL type: {@link PxCudaContextManager}
     * @return WebIDL type: {@link PxParticleAndDiffuseBuffer}
     */
    public static PxParticleAndDiffuseBuffer CreateAndPopulateParticleAndDiffuseBuffer(PxParticleAndDiffuseBufferDesc desc, PxCudaContextManager cudaContextManager) {
        return PxParticleAndDiffuseBuffer.wrapPointer(_CreateAndPopulateParticleAndDiffuseBuffer(desc.getAddress(), cudaContextManager.getAddress()));
    }
    private static native long _CreateAndPopulateParticleAndDiffuseBuffer(long desc, long cudaContextManager);

    /**
     * @param vertexCount        WebIDL type: unsigned long
     * @param inVertices         WebIDL type: {@link PxVec4}
     * @param triangleIndexCount WebIDL type: unsigned long
     * @param inTriangleIndices  WebIDL type: {@link PxU32Ptr} [Ref]
     * @return WebIDL type: {@link PxParticleClothCooker}
     */
    public static PxParticleClothCooker CreateParticleClothCooker(int vertexCount, PxVec4 inVertices, int triangleIndexCount, PxU32Ptr inTriangleIndices) {
        return PxParticleClothCooker.wrapPointer(_CreateParticleClothCooker(vertexCount, inVertices.getAddress(), triangleIndexCount, inTriangleIndices.getAddress()));
    }
    private static native long _CreateParticleClothCooker(int vertexCount, long inVertices, int triangleIndexCount, long inTriangleIndices);

    /**
     * @param vertexCount         WebIDL type: unsigned long
     * @param inVertices          WebIDL type: {@link PxVec4}
     * @param triangleIndexCount  WebIDL type: unsigned long
     * @param inTriangleIndices   WebIDL type: {@link PxU32Ptr} [Ref]
     * @param constraintTypeFlags WebIDL type: unsigned long
     * @return WebIDL type: {@link PxParticleClothCooker}
     */
    public static PxParticleClothCooker CreateParticleClothCooker(int vertexCount, PxVec4 inVertices, int triangleIndexCount, PxU32Ptr inTriangleIndices, int constraintTypeFlags) {
        return PxParticleClothCooker.wrapPointer(_CreateParticleClothCooker(vertexCount, inVertices.getAddress(), triangleIndexCount, inTriangleIndices.getAddress(), constraintTypeFlags));
    }
    private static native long _CreateParticleClothCooker(int vertexCount, long inVertices, int triangleIndexCount, long inTriangleIndices, int constraintTypeFlags);

    /**
     * @param vertexCount         WebIDL type: unsigned long
     * @param inVertices          WebIDL type: {@link PxVec4}
     * @param triangleIndexCount  WebIDL type: unsigned long
     * @param inTriangleIndices   WebIDL type: {@link PxU32Ptr} [Ref]
     * @param constraintTypeFlags WebIDL type: unsigned long
     * @param verticalDirection   WebIDL type: {@link PxVec3} [Ref]
     * @return WebIDL type: {@link PxParticleClothCooker}
     */
    public static PxParticleClothCooker CreateParticleClothCooker(int vertexCount, PxVec4 inVertices, int triangleIndexCount, PxU32Ptr inTriangleIndices, int constraintTypeFlags, PxVec3 verticalDirection) {
        return PxParticleClothCooker.wrapPointer(_CreateParticleClothCooker(vertexCount, inVertices.getAddress(), triangleIndexCount, inTriangleIndices.getAddress(), constraintTypeFlags, verticalDirection.getAddress()));
    }
    private static native long _CreateParticleClothCooker(int vertexCount, long inVertices, int triangleIndexCount, long inTriangleIndices, int constraintTypeFlags, long verticalDirection);

    /**
     * @param vertexCount               WebIDL type: unsigned long
     * @param inVertices                WebIDL type: {@link PxVec4}
     * @param triangleIndexCount        WebIDL type: unsigned long
     * @param inTriangleIndices         WebIDL type: {@link PxU32Ptr} [Ref]
     * @param constraintTypeFlags       WebIDL type: unsigned long
     * @param verticalDirection         WebIDL type: {@link PxVec3} [Ref]
     * @param bendingConstraintMaxAngle WebIDL type: float
     * @return WebIDL type: {@link PxParticleClothCooker}
     */
    public static PxParticleClothCooker CreateParticleClothCooker(int vertexCount, PxVec4 inVertices, int triangleIndexCount, PxU32Ptr inTriangleIndices, int constraintTypeFlags, PxVec3 verticalDirection, float bendingConstraintMaxAngle) {
        return PxParticleClothCooker.wrapPointer(_CreateParticleClothCooker(vertexCount, inVertices.getAddress(), triangleIndexCount, inTriangleIndices.getAddress(), constraintTypeFlags, verticalDirection.getAddress(), bendingConstraintMaxAngle));
    }
    private static native long _CreateParticleClothCooker(int vertexCount, long inVertices, int triangleIndexCount, long inTriangleIndices, int constraintTypeFlags, long verticalDirection, float bendingConstraintMaxAngle);

    /**
     * @param cudaContextManager WebIDL type: {@link PxCudaContextManager}
     * @param numElements        WebIDL type: unsigned long
     * @return WebIDL type: VoidPtr
     */
    public static NativeObject allocPinnedHostBufferPxU32(PxCudaContextManager cudaContextManager, int numElements) {
        return NativeObject.wrapPointer(_allocPinnedHostBufferPxU32(cudaContextManager.getAddress(), numElements));
    }
    private static native long _allocPinnedHostBufferPxU32(long cudaContextManager, int numElements);

    /**
     * @param cudaContextManager WebIDL type: {@link PxCudaContextManager}
     * @param numElements        WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVec4}
     */
    public static PxVec4 allocPinnedHostBufferPxVec4(PxCudaContextManager cudaContextManager, int numElements) {
        return PxVec4.wrapPointer(_allocPinnedHostBufferPxVec4(cudaContextManager.getAddress(), numElements));
    }
    private static native long _allocPinnedHostBufferPxVec4(long cudaContextManager, int numElements);

    /**
     * @param cudaContextManager WebIDL type: {@link PxCudaContextManager}
     * @param buffer             WebIDL type: {@link PxU32Ptr} [Ref]
     */
    public static void freePinnedHostBufferPxU32(PxCudaContextManager cudaContextManager, PxU32Ptr buffer) {
        _freePinnedHostBufferPxU32(cudaContextManager.getAddress(), buffer.getAddress());
    }
    private static native void _freePinnedHostBufferPxU32(long cudaContextManager, long buffer);

    /**
     * @param cudaContextManager WebIDL type: {@link PxCudaContextManager}
     * @param buffer             WebIDL type: {@link PxVec4}
     */
    public static void freePinnedHostBufferPxVec4(PxCudaContextManager cudaContextManager, PxVec4 buffer) {
        _freePinnedHostBufferPxVec4(cudaContextManager.getAddress(), buffer.getAddress());
    }
    private static native void _freePinnedHostBufferPxVec4(long cudaContextManager, long buffer);

    /**
     * @param pxU32data WebIDL type: VoidPtr
     * @return WebIDL type: unsigned long long
     */
    public static long pxU32deviceptr(NativeObject pxU32data) {
        return _pxU32deviceptr(pxU32data.getAddress());
    }
    private static native long _pxU32deviceptr(long pxU32data);

    /**
     * @param pxVec4data WebIDL type: {@link PxVec4}
     * @return WebIDL type: unsigned long long
     */
    public static long pxVec4deviceptr(PxVec4 pxVec4data) {
        return _pxVec4deviceptr(pxVec4data.getAddress());
    }
    private static native long _pxVec4deviceptr(long pxVec4data);

}
