package physx.cooking;

/**
 * Enumeration for convex mesh cooking algorithms. 
 */
public enum PxConvexMeshCookingTypeEnum {

    /**
     * The Quickhull algorithm constructs the hull from the given input points. The resulting hull
     * will only contain a subset of the input points. 
     */
    eQUICKHULL(geteQUICKHULL());
    public final int value;
    
    PxConvexMeshCookingTypeEnum(int value) {
        this.value = value;
    }

    private static native int _geteQUICKHULL();
    private static int geteQUICKHULL() {
        de.fabmax.physxjni.Loader.load();
        return _geteQUICKHULL();
    }

    public static PxConvexMeshCookingTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxConvexMeshCookingTypeEnum: " + value);
    }

}
