package physx.geometry;

import physx.common.PxBase;

public class PxBVHStructure extends PxBase {

    protected PxBVHStructure() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBVHStructure wrapPointer(long address) {
        return address != 0L ? new PxBVHStructure(address) : null;
    }
    
    public static PxBVHStructure arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBVHStructure(long address) {
        super(address);
    }

}
