package physx.geometry;

import physx.NativeObject;

public class PxTriangleMeshFlags extends NativeObject {

    protected PxTriangleMeshFlags() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxTriangleMeshFlags wrapPointer(long address) {
        return address != 0L ? new PxTriangleMeshFlags(address) : null;
    }
    
    public static PxTriangleMeshFlags arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxTriangleMeshFlags(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param flags   WebIDL type: octet
     * @return Stack allocated object of PxTriangleMeshFlags
     */
    public static PxTriangleMeshFlags createAt(long address, byte flags) {
        __placement_new_PxTriangleMeshFlags(address, flags);
        PxTriangleMeshFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     WebIDL type: octet
     * @return Stack allocated object of PxTriangleMeshFlags
     */
    public static <T> PxTriangleMeshFlags createAt(T allocator, Allocator<T> allocate, byte flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTriangleMeshFlags(address, flags);
        PxTriangleMeshFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTriangleMeshFlags(long address, byte flags);

    // Constructors

    /**
     * @param flags WebIDL type: octet
     */
    public PxTriangleMeshFlags(byte flags) {
        address = _PxTriangleMeshFlags(flags);
    }
    private static native long _PxTriangleMeshFlags(byte flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxTriangleMeshFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(PxTriangleMeshFlagEnum flag) {
        checkNotNull();
        return _isSet(address, flag.value);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxTriangleMeshFlagEnum} [enum]
     */
    public void raise(PxTriangleMeshFlagEnum flag) {
        checkNotNull();
        _raise(address, flag.value);
    }
    private static native void _raise(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxTriangleMeshFlagEnum} [enum]
     */
    public void clear(PxTriangleMeshFlagEnum flag) {
        checkNotNull();
        _clear(address, flag.value);
    }
    private static native void _clear(long address, int flag);

}
