package physx.particles;

import physx.NativeObject;

public class PxGpuMirroredGpuParticleSystemPointer extends NativeObject {

    protected PxGpuMirroredGpuParticleSystemPointer() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxGpuMirroredGpuParticleSystemPointer wrapPointer(long address) {
        return address != 0L ? new PxGpuMirroredGpuParticleSystemPointer(address) : null;
    }
    
    public static PxGpuMirroredGpuParticleSystemPointer arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxGpuMirroredGpuParticleSystemPointer(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxGpuParticleSystem}
     */
    public PxGpuParticleSystem getMDevicePtr() {
        checkNotNull();
        return PxGpuParticleSystem.wrapPointer(_getMDevicePtr(address));
    }
    private static native long _getMDevicePtr(long address);

    /**
     * @param value WebIDL type: {@link PxGpuParticleSystem}
     */
    public void setMDevicePtr(PxGpuParticleSystem value) {
        checkNotNull();
        _setMDevicePtr(address, value.getAddress());
    }
    private static native void _setMDevicePtr(long address, long value);

    /**
     * @return WebIDL type: {@link PxGpuParticleSystem}
     */
    public PxGpuParticleSystem getMHostPtr() {
        checkNotNull();
        return PxGpuParticleSystem.wrapPointer(_getMHostPtr(address));
    }
    private static native long _getMHostPtr(long address);

    /**
     * @param value WebIDL type: {@link PxGpuParticleSystem}
     */
    public void setMHostPtr(PxGpuParticleSystem value) {
        checkNotNull();
        _setMHostPtr(address, value.getAddress());
    }
    private static native void _setMHostPtr(long address, long value);

}
