package physx.particles;

import physx.NativeObject;
import physx.common.PxVec4;
import physx.support.PxU32Ptr;

/**
 * Structure to define user-defined particle state when constructing a new particle system.
 */
public class PxParticleBufferDesc extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleBufferDesc wrapPointer(long address) {
        return address != 0L ? new PxParticleBufferDesc(address) : null;
    }
    
    public static PxParticleBufferDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleBufferDesc(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxParticleBufferDesc
     */
    public static PxParticleBufferDesc createAt(long address) {
        __placement_new_PxParticleBufferDesc(address);
        PxParticleBufferDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxParticleBufferDesc
     */
    public static <T> PxParticleBufferDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxParticleBufferDesc(address);
        PxParticleBufferDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxParticleBufferDesc(long address);

    // Constructors

    public PxParticleBufferDesc() {
        address = _PxParticleBufferDesc();
    }
    private static native long _PxParticleBufferDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     */
    public PxVec4 getPositions() {
        checkNotNull();
        return PxVec4.wrapPointer(_getPositions(address));
    }
    private static native long _getPositions(long address);

    /**
     */
    public void setPositions(PxVec4 value) {
        checkNotNull();
        _setPositions(address, value.getAddress());
    }
    private static native void _setPositions(long address, long value);

    /**
     */
    public PxVec4 getVelocities() {
        checkNotNull();
        return PxVec4.wrapPointer(_getVelocities(address));
    }
    private static native long _getVelocities(long address);

    /**
     */
    public void setVelocities(PxVec4 value) {
        checkNotNull();
        _setVelocities(address, value.getAddress());
    }
    private static native void _setVelocities(long address, long value);

    /**
     */
    public PxU32Ptr getPhases() {
        checkNotNull();
        return PxU32Ptr.wrapPointer(_getPhases(address));
    }
    private static native long _getPhases(long address);

    /**
     */
    public void setPhases(PxU32Ptr value) {
        checkNotNull();
        _setPhases(address, value.getAddress());
    }
    private static native void _setPhases(long address, long value);

    /**
     */
    public PxParticleVolume getVolumes() {
        checkNotNull();
        return PxParticleVolume.wrapPointer(_getVolumes(address));
    }
    private static native long _getVolumes(long address);

    /**
     */
    public void setVolumes(PxParticleVolume value) {
        checkNotNull();
        _setVolumes(address, value.getAddress());
    }
    private static native void _setVolumes(long address, long value);

    /**
     */
    public int getNumActiveParticles() {
        checkNotNull();
        return _getNumActiveParticles(address);
    }
    private static native int _getNumActiveParticles(long address);

    /**
     */
    public void setNumActiveParticles(int value) {
        checkNotNull();
        _setNumActiveParticles(address, value);
    }
    private static native void _setNumActiveParticles(long address, int value);

    /**
     */
    public int getMaxParticles() {
        checkNotNull();
        return _getMaxParticles(address);
    }
    private static native int _getMaxParticles(long address);

    /**
     */
    public void setMaxParticles(int value) {
        checkNotNull();
        _setMaxParticles(address, value);
    }
    private static native void _setMaxParticles(long address, int value);

    /**
     */
    public int getNumVolumes() {
        checkNotNull();
        return _getNumVolumes(address);
    }
    private static native int _getNumVolumes(long address);

    /**
     */
    public void setNumVolumes(int value) {
        checkNotNull();
        _setNumVolumes(address, value);
    }
    private static native void _setNumVolumes(long address, int value);

    /**
     */
    public int getMaxVolumes() {
        checkNotNull();
        return _getMaxVolumes(address);
    }
    private static native int _getMaxVolumes(long address);

    /**
     */
    public void setMaxVolumes(int value) {
        checkNotNull();
        _setMaxVolumes(address, value);
    }
    private static native void _setMaxVolumes(long address, int value);

}
