package physx.particles;

/**
 * Identifies dirty particle buffers that need to be updated in the particle system.
 * <p>
 * This flag can be used mark the device user buffers that are dirty and need to be written to the particle system.
 */
public enum PxParticleBufferFlagEnum {

    /**
     * No data specified
     */
    eNONE(geteNONE()),
    /**
     * Specifies the position (first 3 floats) and inverse mass (last float) data (array of PxVec4 * number of particles)
     */
    eUPDATE_POSITION(geteUPDATE_POSITION()),
    /**
     * Specifies the velocity (first 3 floats) data (array of PxVec4 * number of particles)
     */
    eUPDATE_VELOCITY(geteUPDATE_VELOCITY()),
    /**
     * Specifies the per-particle phase flag data (array of PxU32 * number of particles)
     */
    eUPDATE_PHASE(geteUPDATE_PHASE()),
    /**
     * Specifies the rest position (first 3 floats) data for cloth buffers
     */
    eUPDATE_RESTPOSITION(geteUPDATE_RESTPOSITION()),
    /**
     * Specifies the cloth buffer (see PxParticleClothBuffer)
     */
    eUPDATE_CLOTH(geteUPDATE_CLOTH()),
    /**
     * Specifies the rigid buffer (see PxParticleRigidBuffer)
     */
    eUPDATE_RIGID(geteUPDATE_RIGID()),
    /**
     * Specifies the diffuse particle parameter buffer (see PxDiffuseParticleParams)
     */
    eUPDATE_DIFFUSE_PARAM(geteUPDATE_DIFFUSE_PARAM()),
    /**
     * Specifies the attachments.
     */
    eUPDATE_ATTACHMENTS(geteUPDATE_ATTACHMENTS()),
    eALL(geteALL());
    public final int value;
    
    PxParticleBufferFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteNONE();
    private static int geteNONE() {
        de.fabmax.physxjni.Loader.load();
        return _geteNONE();
    }

    private static native int _geteUPDATE_POSITION();
    private static int geteUPDATE_POSITION() {
        de.fabmax.physxjni.Loader.load();
        return _geteUPDATE_POSITION();
    }

    private static native int _geteUPDATE_VELOCITY();
    private static int geteUPDATE_VELOCITY() {
        de.fabmax.physxjni.Loader.load();
        return _geteUPDATE_VELOCITY();
    }

    private static native int _geteUPDATE_PHASE();
    private static int geteUPDATE_PHASE() {
        de.fabmax.physxjni.Loader.load();
        return _geteUPDATE_PHASE();
    }

    private static native int _geteUPDATE_RESTPOSITION();
    private static int geteUPDATE_RESTPOSITION() {
        de.fabmax.physxjni.Loader.load();
        return _geteUPDATE_RESTPOSITION();
    }

    private static native int _geteUPDATE_CLOTH();
    private static int geteUPDATE_CLOTH() {
        de.fabmax.physxjni.Loader.load();
        return _geteUPDATE_CLOTH();
    }

    private static native int _geteUPDATE_RIGID();
    private static int geteUPDATE_RIGID() {
        de.fabmax.physxjni.Loader.load();
        return _geteUPDATE_RIGID();
    }

    private static native int _geteUPDATE_DIFFUSE_PARAM();
    private static int geteUPDATE_DIFFUSE_PARAM() {
        de.fabmax.physxjni.Loader.load();
        return _geteUPDATE_DIFFUSE_PARAM();
    }

    private static native int _geteUPDATE_ATTACHMENTS();
    private static int geteUPDATE_ATTACHMENTS() {
        de.fabmax.physxjni.Loader.load();
        return _geteUPDATE_ATTACHMENTS();
    }

    private static native int _geteALL();
    private static int geteALL() {
        de.fabmax.physxjni.Loader.load();
        return _geteALL();
    }

    public static PxParticleBufferFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxParticleBufferFlagEnum: " + value);
    }

}
