package physx.particles;

import physx.NativeObject;

public class PxParticleClothConstraint extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleClothConstraint wrapPointer(long address) {
        return address != 0L ? new PxParticleClothConstraint(address) : null;
    }
    
    public static PxParticleClothConstraint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleClothConstraint(long address) {
        super(address);
    }

    // Constructors

    public PxParticleClothConstraint() {
        address = _PxParticleClothConstraint();
    }
    private static native long _PxParticleClothConstraint();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getParticleIndexA() {
        checkNotNull();
        return _getParticleIndexA(address);
    }
    private static native int _getParticleIndexA(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setParticleIndexA(int value) {
        checkNotNull();
        _setParticleIndexA(address, value);
    }
    private static native void _setParticleIndexA(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getParticleIndexB() {
        checkNotNull();
        return _getParticleIndexB(address);
    }
    private static native int _getParticleIndexB(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setParticleIndexB(int value) {
        checkNotNull();
        _setParticleIndexB(address, value);
    }
    private static native void _setParticleIndexB(long address, int value);

    /**
     * @return WebIDL type: float
     */
    public float getLength() {
        checkNotNull();
        return _getLength(address);
    }
    private static native float _getLength(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setLength(float value) {
        checkNotNull();
        _setLength(address, value);
    }
    private static native void _setLength(long address, float value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getConstraintType() {
        checkNotNull();
        return _getConstraintType(address);
    }
    private static native int _getConstraintType(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setConstraintType(int value) {
        checkNotNull();
        _setConstraintType(address, value);
    }
    private static native void _setConstraintType(long address, int value);

}
