package physx.particles;

import physx.NativeObject;

public class PxParticleClothCooker extends NativeObject {

    protected PxParticleClothCooker() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleClothCooker wrapPointer(long address) {
        return address != 0L ? new PxParticleClothCooker(address) : null;
    }
    
    public static PxParticleClothCooker arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleClothCooker(long address) {
        super(address);
    }

    // Functions

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    /**
     * Generate the constraint list and triangle index list.
     */
    public void cookConstraints() {
        checkNotNull();
        _cookConstraints(address);
    }
    private static native void _cookConstraints(long address);

    /**
     * Generate the constraint list and triangle index list.
     * @param constraints A pointer to an array of PxParticleClothConstraint constraints. If NULL, the cooker will generate all the constraints. Otherwise, the user-provided constraints will be added. 
     */
    public void cookConstraints(PxParticleClothConstraint constraints) {
        checkNotNull();
        _cookConstraints(address, constraints.getAddress());
    }
    private static native void _cookConstraints(long address, long constraints);

    /**
     * Generate the constraint list and triangle index list.
     * @param constraints A pointer to an array of PxParticleClothConstraint constraints. If NULL, the cooker will generate all the constraints. Otherwise, the user-provided constraints will be added. 
     * @param numConstraints The number of user-provided PxParticleClothConstraint s. 
     */
    public void cookConstraints(PxParticleClothConstraint constraints, int numConstraints) {
        checkNotNull();
        _cookConstraints(address, constraints.getAddress(), numConstraints);
    }
    private static native void _cookConstraints(long address, long constraints, int numConstraints);

    /**
     * @return A pointer to the triangle indices.
     */
    public NativeObject getTriangleIndices() {
        checkNotNull();
        return NativeObject.wrapPointer(_getTriangleIndices(address));
    }
    private static native long _getTriangleIndices(long address);

    /**
     * @return The number of triangle indices.
     */
    public int getTriangleIndicesCount() {
        checkNotNull();
        return _getTriangleIndicesCount(address);
    }
    private static native int _getTriangleIndicesCount(long address);

    /**
     * @return A pointer to the PxParticleClothConstraint constraints.
     */
    public PxParticleClothConstraint getConstraints() {
        checkNotNull();
        return PxParticleClothConstraint.wrapPointer(_getConstraints(address));
    }
    private static native long _getConstraints(long address);

    /**
     * @return The number of constraints.
     */
    public int getConstraintCount() {
        checkNotNull();
        return _getConstraintCount(address);
    }
    private static native int _getConstraintCount(long address);

    /**
     * Computes the volume of a closed mesh and the contraintScale. Expects vertices in local space - 'close' to origin.
     */
    public void calculateMeshVolume() {
        checkNotNull();
        _calculateMeshVolume(address);
    }
    private static native void _calculateMeshVolume(long address);

    /**
     * @return The mesh volume calculated by PxParticleClothCooker::calculateMeshVolume.
     */
    public float getMeshVolume() {
        checkNotNull();
        return _getMeshVolume(address);
    }
    private static native float _getMeshVolume(long address);

}
