package physx.particles;

/**
 * Identifies per-particle behavior for a PxParticleSystem.
 * <p>
 * See #PxParticleSystem::createPhase().
 */
public enum PxParticlePhaseFlagEnum {

    /**
     * Bits [ 0, 19] represent the particle group for controlling collisions
     */
    eParticlePhaseGroupMask(geteParticlePhaseGroupMask()),
    /**
     * Bits [20, 23] hold flags about how the particle behave
     */
    eParticlePhaseFlagsMask(geteParticlePhaseFlagsMask()),
    /**
     * If set this particle will interact with particles of the same group
     */
    eParticlePhaseSelfCollide(geteParticlePhaseSelfCollide()),
    /**
     * If set this particle will ignore collisions with particles closer than the radius in the rest pose, this flag should not be specified unless valid rest positions have been specified using setRestParticles()
     */
    eParticlePhaseSelfCollideFilter(geteParticlePhaseSelfCollideFilter()),
    eParticlePhaseFluid(geteParticlePhaseFluid());
    public final int value;
    
    PxParticlePhaseFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteParticlePhaseGroupMask();
    private static int geteParticlePhaseGroupMask() {
        de.fabmax.physxjni.Loader.load();
        return _geteParticlePhaseGroupMask();
    }

    private static native int _geteParticlePhaseFlagsMask();
    private static int geteParticlePhaseFlagsMask() {
        de.fabmax.physxjni.Loader.load();
        return _geteParticlePhaseFlagsMask();
    }

    private static native int _geteParticlePhaseSelfCollide();
    private static int geteParticlePhaseSelfCollide() {
        de.fabmax.physxjni.Loader.load();
        return _geteParticlePhaseSelfCollide();
    }

    private static native int _geteParticlePhaseSelfCollideFilter();
    private static int geteParticlePhaseSelfCollideFilter() {
        de.fabmax.physxjni.Loader.load();
        return _geteParticlePhaseSelfCollideFilter();
    }

    private static native int _geteParticlePhaseFluid();
    private static int geteParticlePhaseFluid() {
        de.fabmax.physxjni.Loader.load();
        return _geteParticlePhaseFluid();
    }

    public static PxParticlePhaseFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxParticlePhaseFlagEnum: " + value);
    }

}
