package physx.particles;

import physx.common.PxVec4;

/**
 * Struct to specify attachment between a particle/vertex and a rigid
 */
public class PxParticleRigidAttachment extends PxParticleRigidFilterPair {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleRigidAttachment wrapPointer(long address) {
        return address != 0L ? new PxParticleRigidAttachment(address) : null;
    }
    
    public static PxParticleRigidAttachment arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleRigidAttachment(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxParticleRigidAttachment
     */
    public static PxParticleRigidAttachment createAt(long address) {
        __placement_new_PxParticleRigidAttachment(address);
        PxParticleRigidAttachment createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxParticleRigidAttachment
     */
    public static <T> PxParticleRigidAttachment createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxParticleRigidAttachment(address);
        PxParticleRigidAttachment createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxParticleRigidAttachment(long address);

    // Constructors

    public PxParticleRigidAttachment() {
        address = _PxParticleRigidAttachment();
    }
    private static native long _PxParticleRigidAttachment();

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec4} [Value]
     */
    public PxVec4 getMLocalPose0() {
        checkNotNull();
        return PxVec4.wrapPointer(_getMLocalPose0(address));
    }
    private static native long _getMLocalPose0(long address);

    /**
     * @param value WebIDL type: {@link PxVec4} [Value]
     */
    public void setMLocalPose0(PxVec4 value) {
        checkNotNull();
        _setMLocalPose0(address, value.getAddress());
    }
    private static native void _setMLocalPose0(long address, long value);

    /**
     * Parameters to specify cone constraints
     */
    public PxConeLimitParams getMParams() {
        checkNotNull();
        return PxConeLimitParams.wrapPointer(_getMParams(address));
    }
    private static native long _getMParams(long address);

    /**
     * Parameters to specify cone constraints
     */
    public void setMParams(PxConeLimitParams value) {
        checkNotNull();
        _setMParams(address, value.getAddress());
    }
    private static native void _setMParams(long address, long value);

}
