package physx.particles;

import physx.NativeObject;

/**
 * Struct for storing a particle/vertex - rigid filter pair with comparison operators
 */
public class PxParticleRigidFilterPair extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleRigidFilterPair wrapPointer(long address) {
        return address != 0L ? new PxParticleRigidFilterPair(address) : null;
    }
    
    public static PxParticleRigidFilterPair arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleRigidFilterPair(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxParticleRigidFilterPair
     */
    public static PxParticleRigidFilterPair createAt(long address) {
        __placement_new_PxParticleRigidFilterPair(address);
        PxParticleRigidFilterPair createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxParticleRigidFilterPair
     */
    public static <T> PxParticleRigidFilterPair createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxParticleRigidFilterPair(address);
        PxParticleRigidFilterPair createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxParticleRigidFilterPair(long address);

    // Constructors

    public PxParticleRigidFilterPair() {
        address = _PxParticleRigidFilterPair();
    }
    private static native long _PxParticleRigidFilterPair();

    // Attributes

    /**
     * Rigid node index
     */
    public long getMID0() {
        checkNotNull();
        return _getMID0(address);
    }
    private static native long _getMID0(long address);

    /**
     * Rigid node index
     */
    public void setMID0(long value) {
        checkNotNull();
        _setMID0(address, value);
    }
    private static native void _setMID0(long address, long value);

    /**
     * Particle/vertex id
     */
    public long getMID1() {
        checkNotNull();
        return _getMID1(address);
    }
    private static native long _getMID1(long address);

    /**
     * Particle/vertex id
     */
    public void setMID1(long value) {
        checkNotNull();
        _setMID1(address, value);
    }
    private static native void _setMID1(long address, long value);

}
