package physx.particles;

import physx.NativeObject;
import physx.common.PxBounds3;

/**
 * Particle volume structure. Used to track the bounding volume of a user-specified set of particles. The particles are required
 * to be laid out contiguously within the same PxParticleBuffer.
 */
public class PxParticleVolume extends NativeObject {

    protected PxParticleVolume() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleVolume wrapPointer(long address) {
        return address != 0L ? new PxParticleVolume(address) : null;
    }
    
    public static PxParticleVolume arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleVolume(long address) {
        super(address);
    }

    // Attributes

    /**
     * The current bounds of the particles contained in this #PxParticleVolume.
     */
    public PxBounds3 getBound() {
        checkNotNull();
        return PxBounds3.wrapPointer(_getBound(address));
    }
    private static native long _getBound(long address);

    /**
     * The current bounds of the particles contained in this #PxParticleVolume.
     */
    public void setBound(PxBounds3 value) {
        checkNotNull();
        _setBound(address, value.getAddress());
    }
    private static native void _setBound(long address, long value);

    /**
     * The index into the particle list of the #PxParticleBuffer for the first particle of this volume.
     */
    public int getParticleIndicesOffset() {
        checkNotNull();
        return _getParticleIndicesOffset(address);
    }
    private static native int _getParticleIndicesOffset(long address);

    /**
     * The index into the particle list of the #PxParticleBuffer for the first particle of this volume.
     */
    public void setParticleIndicesOffset(int value) {
        checkNotNull();
        _setParticleIndicesOffset(address, value);
    }
    private static native void _setParticleIndicesOffset(long address, int value);

    /**
     * The number of particles contained in this #PxParticleVolume.
     */
    public int getNumParticles() {
        checkNotNull();
        return _getNumParticles(address);
    }
    private static native int _getNumParticles(long address);

    /**
     * The number of particles contained in this #PxParticleVolume.
     */
    public void setNumParticles(int value) {
        checkNotNull();
        _setNumParticles(address, value);
    }
    private static native void _setNumParticles(long address, int value);

}
