package physx.physics;

/**
 *   \addtogroup physics
 * @{ 
 */
public enum PxArticulationAxisEnum {

    /**
     * Rotational about eX
     */
    eTWIST(geteTWIST()),
    /**
     * Rotational about eY
     */
    eSWING1(geteSWING1()),
    /**
     * Rotational about eZ
     */
    eSWING2(geteSWING2()),
    /**
     * Linear in eX
     */
    eX(geteX()),
    /**
     * Linear in eY
     */
    eY(geteY()),
    /**
     * Linear in eZ
     */
    eZ(geteZ());
    public final int value;
    
    PxArticulationAxisEnum(int value) {
        this.value = value;
    }

    private static native int _geteTWIST();
    private static int geteTWIST() {
        de.fabmax.physxjni.Loader.load();
        return _geteTWIST();
    }

    private static native int _geteSWING1();
    private static int geteSWING1() {
        de.fabmax.physxjni.Loader.load();
        return _geteSWING1();
    }

    private static native int _geteSWING2();
    private static int geteSWING2() {
        de.fabmax.physxjni.Loader.load();
        return _geteSWING2();
    }

    private static native int _geteX();
    private static int geteX() {
        de.fabmax.physxjni.Loader.load();
        return _geteX();
    }

    private static native int _geteY();
    private static int geteY() {
        de.fabmax.physxjni.Loader.load();
        return _geteY();
    }

    private static native int _geteZ();
    private static int geteZ() {
        de.fabmax.physxjni.Loader.load();
        return _geteZ();
    }

    public static PxArticulationAxisEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationAxisEnum: " + value);
    }

}
