package physx.physics;

import physx.NativeObject;

/**
 * Data structure for articulation joint drive configuration.
 * @see PxArticulationReducedCoordinate
 */
public class PxArticulationDrive extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationDrive wrapPointer(long address) {
        return address != 0L ? new PxArticulationDrive(address) : null;
    }
    
    public static PxArticulationDrive arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationDrive(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxArticulationDrive
     */
    public static PxArticulationDrive createAt(long address) {
        __placement_new_PxArticulationDrive(address);
        PxArticulationDrive createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxArticulationDrive
     */
    public static <T> PxArticulationDrive createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArticulationDrive(address);
        PxArticulationDrive createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArticulationDrive(long address);

    /**
     * @param address   Pre-allocated memory, where the object is created.
     * @param stiffness WebIDL type: float
     * @param damping   WebIDL type: float
     * @param maxForce  WebIDL type: float
     * @param driveType WebIDL type: {@link PxArticulationDriveTypeEnum} [enum]
     * @return Stack allocated object of PxArticulationDrive
     */
    public static PxArticulationDrive createAt(long address, float stiffness, float damping, float maxForce, PxArticulationDriveTypeEnum driveType) {
        __placement_new_PxArticulationDrive(address, stiffness, damping, maxForce, driveType.value);
        PxArticulationDrive createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param stiffness WebIDL type: float
     * @param damping   WebIDL type: float
     * @param maxForce  WebIDL type: float
     * @param driveType WebIDL type: {@link PxArticulationDriveTypeEnum} [enum]
     * @return Stack allocated object of PxArticulationDrive
     */
    public static <T> PxArticulationDrive createAt(T allocator, Allocator<T> allocate, float stiffness, float damping, float maxForce, PxArticulationDriveTypeEnum driveType) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArticulationDrive(address, stiffness, damping, maxForce, driveType.value);
        PxArticulationDrive createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArticulationDrive(long address, float stiffness, float damping, float maxForce, int driveType);

    // Constructors

    public PxArticulationDrive() {
        address = _PxArticulationDrive();
    }
    private static native long _PxArticulationDrive();

    /**
     * @param stiffness WebIDL type: float
     * @param damping   WebIDL type: float
     * @param maxForce  WebIDL type: float
     * @param driveType WebIDL type: {@link PxArticulationDriveTypeEnum} [enum]
     */
    public PxArticulationDrive(float stiffness, float damping, float maxForce, PxArticulationDriveTypeEnum driveType) {
        address = _PxArticulationDrive(stiffness, damping, maxForce, driveType.value);
    }
    private static native long _PxArticulationDrive(float stiffness, float damping, float maxForce, int driveType);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The drive stiffness, i.e. the proportional gain of the implicit PD controller.
     * <p>
     * See manual for further information, and the drives' implicit spring-damper (i.e. PD control) implementation in particular.
     * <p>
     * <b>Units:</b> (distance = linear scene units)<br>
     * Rotational axis: torque/rad if driveType = PxArticulationDriveType::eFORCE; or (rad/s^2)/rad if driveType = PxArticulationDriveType::eACCELERATION<br>
     * Translational axis: force/distance if driveType = PxArticulationDriveType::eFORCE; or (distance/s^2)/distance if driveType = PxArticulationDriveType::eACCELERATION<br>
     * <b>Range:</b> [0, PX_MAX_F32]<br>
     * <b>Default:</b> 0.0f<br>
     */
    public float getStiffness() {
        checkNotNull();
        return _getStiffness(address);
    }
    private static native float _getStiffness(long address);

    /**
     * The drive stiffness, i.e. the proportional gain of the implicit PD controller.
     * <p>
     * See manual for further information, and the drives' implicit spring-damper (i.e. PD control) implementation in particular.
     * <p>
     * <b>Units:</b> (distance = linear scene units)<br>
     * Rotational axis: torque/rad if driveType = PxArticulationDriveType::eFORCE; or (rad/s^2)/rad if driveType = PxArticulationDriveType::eACCELERATION<br>
     * Translational axis: force/distance if driveType = PxArticulationDriveType::eFORCE; or (distance/s^2)/distance if driveType = PxArticulationDriveType::eACCELERATION<br>
     * <b>Range:</b> [0, PX_MAX_F32]<br>
     * <b>Default:</b> 0.0f<br>
     */
    public void setStiffness(float value) {
        checkNotNull();
        _setStiffness(address, value);
    }
    private static native void _setStiffness(long address, float value);

    /**
     * The drive damping, i.e. the derivative gain of the implicit PD controller.
     * <p>
     * See manual for further information, and the drives' implicit spring-damper (i.e. PD control) implementation in particular.
     * <p>
     * <b>Units:</b> (distance = linear scene units)<br>
     * Rotational axis: torque/(rad/s) if driveType = PxArticulationDriveType::eFORCE; or (rad/s^2)/(rad/s) if driveType = PxArticulationDriveType::eACCELERATION<br>
     * Translational axis: force/(distance/s) if driveType = PxArticulationDriveType::eFORCE; or (distance/s^2)/(distance/s) if driveType = PxArticulationDriveType::eACCELERATION<br>
     * <b>Range:</b> [0, PX_MAX_F32]<br>
     * <b>Default:</b> 0.0f<br>
     */
    public float getDamping() {
        checkNotNull();
        return _getDamping(address);
    }
    private static native float _getDamping(long address);

    /**
     * The drive damping, i.e. the derivative gain of the implicit PD controller.
     * <p>
     * See manual for further information, and the drives' implicit spring-damper (i.e. PD control) implementation in particular.
     * <p>
     * <b>Units:</b> (distance = linear scene units)<br>
     * Rotational axis: torque/(rad/s) if driveType = PxArticulationDriveType::eFORCE; or (rad/s^2)/(rad/s) if driveType = PxArticulationDriveType::eACCELERATION<br>
     * Translational axis: force/(distance/s) if driveType = PxArticulationDriveType::eFORCE; or (distance/s^2)/(distance/s) if driveType = PxArticulationDriveType::eACCELERATION<br>
     * <b>Range:</b> [0, PX_MAX_F32]<br>
     * <b>Default:</b> 0.0f<br>
     */
    public void setDamping(float value) {
        checkNotNull();
        _setDamping(address, value);
    }
    private static native void _setDamping(long address, float value);

    /**
     * The drive force limit.
     * <p>
     * - The limit is enforced regardless of the drive type #PxArticulationDriveType.
     * - The limit corresponds to a force (linear axis) or torque (rotational axis) if PxArticulationFlag::eDRIVE_LIMITS_ARE_FORCES is set, and to an impulse (force|torque * dt) otherwise.
     * <p>
     * <b>Range:</b> [0, PX_MAX_F32]<br>
     * <b>Default:</b> 0.0f<br>
     */
    public float getMaxForce() {
        checkNotNull();
        return _getMaxForce(address);
    }
    private static native float _getMaxForce(long address);

    /**
     * The drive force limit.
     * <p>
     * - The limit is enforced regardless of the drive type #PxArticulationDriveType.
     * - The limit corresponds to a force (linear axis) or torque (rotational axis) if PxArticulationFlag::eDRIVE_LIMITS_ARE_FORCES is set, and to an impulse (force|torque * dt) otherwise.
     * <p>
     * <b>Range:</b> [0, PX_MAX_F32]<br>
     * <b>Default:</b> 0.0f<br>
     */
    public void setMaxForce(float value) {
        checkNotNull();
        _setMaxForce(address, value);
    }
    private static native void _setMaxForce(long address, float value);

    /**
     * The drive type.
     */
    public PxArticulationDriveTypeEnum getDriveType() {
        checkNotNull();
        return PxArticulationDriveTypeEnum.forValue(_getDriveType(address));
    }
    private static native int _getDriveType(long address);

    /**
     * The drive type.
     */
    public void setDriveType(PxArticulationDriveTypeEnum value) {
        checkNotNull();
        _setDriveType(address, value.value);
    }
    private static native void _setDriveType(long address, int value);

}
