package physx.physics;

import physx.NativeObject;

/**
 * Information &amp; stats structure for a region
 */
public class PxBroadPhaseRegionInfo extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBroadPhaseRegionInfo wrapPointer(long address) {
        return address != 0L ? new PxBroadPhaseRegionInfo(address) : null;
    }
    
    public static PxBroadPhaseRegionInfo arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBroadPhaseRegionInfo(long address) {
        super(address);
    }

    // Constructors

    public PxBroadPhaseRegionInfo() {
        address = _PxBroadPhaseRegionInfo();
    }
    private static native long _PxBroadPhaseRegionInfo();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * User-provided region data
     */
    public PxBroadPhaseRegion getMRegion() {
        checkNotNull();
        return PxBroadPhaseRegion.wrapPointer(_getMRegion(address));
    }
    private static native long _getMRegion(long address);

    /**
     * User-provided region data
     */
    public void setMRegion(PxBroadPhaseRegion value) {
        checkNotNull();
        _setMRegion(address, value.getAddress());
    }
    private static native void _setMRegion(long address, long value);

    /**
     * Number of static objects in the region
     */
    public int getMNbStaticObjects() {
        checkNotNull();
        return _getMNbStaticObjects(address);
    }
    private static native int _getMNbStaticObjects(long address);

    /**
     * Number of static objects in the region
     */
    public void setMNbStaticObjects(int value) {
        checkNotNull();
        _setMNbStaticObjects(address, value);
    }
    private static native void _setMNbStaticObjects(long address, int value);

    /**
     * Number of dynamic objects in the region
     */
    public int getMNbDynamicObjects() {
        checkNotNull();
        return _getMNbDynamicObjects(address);
    }
    private static native int _getMNbDynamicObjects(long address);

    /**
     * Number of dynamic objects in the region
     */
    public void setMNbDynamicObjects(int value) {
        checkNotNull();
        _setMNbDynamicObjects(address, value);
    }
    private static native void _setMNbDynamicObjects(long address, int value);

    /**
     * True if region is currently used, i.e. it has not been removed
     */
    public boolean getMActive() {
        checkNotNull();
        return _getMActive(address);
    }
    private static native boolean _getMActive(long address);

    /**
     * True if region is currently used, i.e. it has not been removed
     */
    public void setMActive(boolean value) {
        checkNotNull();
        _setMActive(address, value);
    }
    private static native void _setMActive(long address, boolean value);

    /**
     * True if region overlaps other regions (regions that are just touching are not considering overlapping)
     */
    public boolean getMOverlap() {
        checkNotNull();
        return _getMOverlap(address);
    }
    private static native boolean _getMOverlap(long address);

    /**
     * True if region overlaps other regions (regions that are just touching are not considering overlapping)
     */
    public void setMOverlap(boolean value) {
        checkNotNull();
        _setMOverlap(address, value);
    }
    private static native void _setMOverlap(long address, boolean value);

}
