package physx.physics;

import physx.NativeObject;
import physx.common.PxVec3;

/**
 * A contact point as used by contact notification
 */
public class PxContactPairPoint extends NativeObject {

    protected PxContactPairPoint() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxContactPairPoint wrapPointer(long address) {
        return address != 0L ? new PxContactPairPoint(address) : null;
    }
    
    public static PxContactPairPoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxContactPairPoint(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The position of the contact point between the shapes, in world space. 
     */
    public PxVec3 getPosition() {
        checkNotNull();
        return PxVec3.wrapPointer(_getPosition(address));
    }
    private static native long _getPosition(long address);

    /**
     * The position of the contact point between the shapes, in world space. 
     */
    public void setPosition(PxVec3 value) {
        checkNotNull();
        _setPosition(address, value.getAddress());
    }
    private static native void _setPosition(long address, long value);

    /**
     * The separation of the shapes at the contact point.  A negative separation denotes a penetration.
     */
    public float getSeparation() {
        checkNotNull();
        return _getSeparation(address);
    }
    private static native float _getSeparation(long address);

    /**
     * The separation of the shapes at the contact point.  A negative separation denotes a penetration.
     */
    public void setSeparation(float value) {
        checkNotNull();
        _setSeparation(address, value);
    }
    private static native void _setSeparation(long address, float value);

    /**
     * The normal of the contacting surfaces at the contact point. The normal direction points from the second shape to the first shape.
     */
    public PxVec3 getNormal() {
        checkNotNull();
        return PxVec3.wrapPointer(_getNormal(address));
    }
    private static native long _getNormal(long address);

    /**
     * The normal of the contacting surfaces at the contact point. The normal direction points from the second shape to the first shape.
     */
    public void setNormal(PxVec3 value) {
        checkNotNull();
        _setNormal(address, value.getAddress());
    }
    private static native void _setNormal(long address, long value);

    /**
     * The surface index of shape 0 at the contact point.  This is used to identify the surface material.
     */
    public int getInternalFaceIndex0() {
        checkNotNull();
        return _getInternalFaceIndex0(address);
    }
    private static native int _getInternalFaceIndex0(long address);

    /**
     * The surface index of shape 0 at the contact point.  This is used to identify the surface material.
     */
    public void setInternalFaceIndex0(int value) {
        checkNotNull();
        _setInternalFaceIndex0(address, value);
    }
    private static native void _setInternalFaceIndex0(long address, int value);

    /**
     * The impulse applied at the contact point, in world space. Divide by the simulation time step to get a force value.
     */
    public PxVec3 getImpulse() {
        checkNotNull();
        return PxVec3.wrapPointer(_getImpulse(address));
    }
    private static native long _getImpulse(long address);

    /**
     * The impulse applied at the contact point, in world space. Divide by the simulation time step to get a force value.
     */
    public void setImpulse(PxVec3 value) {
        checkNotNull();
        _setImpulse(address, value.getAddress());
    }
    private static native void _setImpulse(long address, long value);

    /**
     * The surface index of shape 1 at the contact point.  This is used to identify the surface material.
     */
    public int getInternalFaceIndex1() {
        checkNotNull();
        return _getInternalFaceIndex1(address);
    }
    private static native int _getInternalFaceIndex1(long address);

    /**
     * The surface index of shape 1 at the contact point.  This is used to identify the surface material.
     */
    public void setInternalFaceIndex1(int value) {
        checkNotNull();
        _setInternalFaceIndex1(address, value);
    }
    private static native void _setInternalFaceIndex1(long address, int value);

}
