package physx.physics;

import physx.NativeObject;

public class PxOverlapCallback extends NativeObject {

    protected PxOverlapCallback() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxOverlapCallback wrapPointer(long address) {
        return address != 0L ? new PxOverlapCallback(address) : null;
    }
    
    public static PxOverlapCallback arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxOverlapCallback(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean hasAnyHits() {
        checkNotNull();
        return _hasAnyHits(address);
    }
    private static native boolean _hasAnyHits(long address);

}
