package physx.physics;


/**
 * PxRigidStatic represents a static rigid body simulation object in the physics SDK.
 * <p>
 * PxRigidStatic objects are static rigid physics entities. They shall be used to define solid objects which are fixed in the world.
 * <p>
 * <h3>Creation</h3>
 * Instances of this class are created by calling #PxPhysics::createRigidStatic() and deleted with #release().
 * <p>
 * <h3>Visualizations</h3>
 * \li #PxVisualizationParameter::eACTOR_AXES
 * @see PxRigidActor
 * @see PxPhysics#createRigidStatic
 */
public class PxRigidStatic extends PxRigidActor {

    protected PxRigidStatic() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxRigidStatic wrapPointer(long address) {
        return address != 0L ? new PxRigidStatic(address) : null;
    }
    
    public static PxRigidStatic arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxRigidStatic(long address) {
        super(address);
    }

}
