package physx.support;

import physx.NativeObject;

public class SimplPvdTransportImpl extends SimplePvdTransport {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static SimplPvdTransportImpl wrapPointer(long address) {
        return address != 0L ? new SimplPvdTransportImpl(address) : null;
    }
    
    public static SimplPvdTransportImpl arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected SimplPvdTransportImpl(long address) {
        super(address);
    }

    protected SimplPvdTransportImpl() {
        address = _SimplPvdTransportImpl();
    }
    private native long _SimplPvdTransportImpl();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private boolean _connect() {
        return connect();
    }

    /**
     * @return WebIDL type: boolean
     */
    public boolean connect() {
        return false;
    }

    /*
     * Called from native code
     */
    private boolean _isConnected() {
        return isConnected();
    }

    /**
     * @return WebIDL type: boolean
     */
    public boolean isConnected() {
        return false;
    }

    /*
     * Called from native code
     */
    private void _disconnect() {
        disconnect();
    }

    public void disconnect() { }

    /*
     * Called from native code
     */
    private void _send(long inBytes, int inLength) {
        send(NativeObject.wrapPointer(inBytes), inLength);
    }

    /**
     * @param inBytes  WebIDL type: any
     * @param inLength WebIDL type: unsigned long
     */
    public void send(NativeObject inBytes, int inLength) { }

    /*
     * Called from native code
     */
    private void _flush() {
        flush();
    }

    public void flush() { }

}
