package physx.support;

import physx.NativeObject;
import physx.physics.PxRaycastHit;

public class Vector_PxRaycastHit extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static Vector_PxRaycastHit wrapPointer(long address) {
        return address != 0L ? new Vector_PxRaycastHit(address) : null;
    }
    
    public static Vector_PxRaycastHit arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected Vector_PxRaycastHit(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxRaycastHit() {
        address = _Vector_PxRaycastHit();
    }
    private static native long _Vector_PxRaycastHit();

    /**
     * @param size WebIDL type: unsigned long
     */
    public Vector_PxRaycastHit(int size) {
        address = _Vector_PxRaycastHit(size);
    }
    private static native long _Vector_PxRaycastHit(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxRaycastHit} [Ref]
     */
    public PxRaycastHit at(int index) {
        checkNotNull();
        return PxRaycastHit.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return WebIDL type: {@link PxRaycastHit}
     */
    public PxRaycastHit data() {
        checkNotNull();
        return PxRaycastHit.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link PxRaycastHit} [Ref]
     */
    public void push_back(PxRaycastHit value) {
        checkNotNull();
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
