package physx.vehicle2;

import physx.NativeObject;

public class EngineDrivetrainState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static EngineDrivetrainState wrapPointer(long address) {
        return address != 0L ? new EngineDrivetrainState(address) : null;
    }
    
    public static EngineDrivetrainState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected EngineDrivetrainState(long address) {
        super(address);
    }

    // Constructors

    public EngineDrivetrainState() {
        address = _EngineDrivetrainState();
    }
    private static native long _EngineDrivetrainState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleEngineDriveThrottleCommandResponseState} [Value]
     */
    public PxVehicleEngineDriveThrottleCommandResponseState getThrottleCommandResponseState() {
        checkNotNull();
        return PxVehicleEngineDriveThrottleCommandResponseState.wrapPointer(_getThrottleCommandResponseState(address));
    }
    private static native long _getThrottleCommandResponseState(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleEngineDriveThrottleCommandResponseState} [Value]
     */
    public void setThrottleCommandResponseState(PxVehicleEngineDriveThrottleCommandResponseState value) {
        checkNotNull();
        _setThrottleCommandResponseState(address, value.getAddress());
    }
    private static native void _setThrottleCommandResponseState(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleAutoboxState} [Value]
     */
    public PxVehicleAutoboxState getAutoboxState() {
        checkNotNull();
        return PxVehicleAutoboxState.wrapPointer(_getAutoboxState(address));
    }
    private static native long _getAutoboxState(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleAutoboxState} [Value]
     */
    public void setAutoboxState(PxVehicleAutoboxState value) {
        checkNotNull();
        _setAutoboxState(address, value.getAddress());
    }
    private static native void _setAutoboxState(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleClutchCommandResponseState} [Value]
     */
    public PxVehicleClutchCommandResponseState getClutchCommandResponseState() {
        checkNotNull();
        return PxVehicleClutchCommandResponseState.wrapPointer(_getClutchCommandResponseState(address));
    }
    private static native long _getClutchCommandResponseState(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleClutchCommandResponseState} [Value]
     */
    public void setClutchCommandResponseState(PxVehicleClutchCommandResponseState value) {
        checkNotNull();
        _setClutchCommandResponseState(address, value.getAddress());
    }
    private static native void _setClutchCommandResponseState(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleDifferentialState} [Value]
     */
    public PxVehicleDifferentialState getDifferentialState() {
        checkNotNull();
        return PxVehicleDifferentialState.wrapPointer(_getDifferentialState(address));
    }
    private static native long _getDifferentialState(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleDifferentialState} [Value]
     */
    public void setDifferentialState(PxVehicleDifferentialState value) {
        checkNotNull();
        _setDifferentialState(address, value.getAddress());
    }
    private static native void _setDifferentialState(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleWheelConstraintGroupState} [Value]
     */
    public PxVehicleWheelConstraintGroupState getWheelConstraintGroupState() {
        checkNotNull();
        return PxVehicleWheelConstraintGroupState.wrapPointer(_getWheelConstraintGroupState(address));
    }
    private static native long _getWheelConstraintGroupState(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleWheelConstraintGroupState} [Value]
     */
    public void setWheelConstraintGroupState(PxVehicleWheelConstraintGroupState value) {
        checkNotNull();
        _setWheelConstraintGroupState(address, value.getAddress());
    }
    private static native void _setWheelConstraintGroupState(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleEngineState} [Value]
     */
    public PxVehicleEngineState getEngineState() {
        checkNotNull();
        return PxVehicleEngineState.wrapPointer(_getEngineState(address));
    }
    private static native long _getEngineState(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleEngineState} [Value]
     */
    public void setEngineState(PxVehicleEngineState value) {
        checkNotNull();
        _setEngineState(address, value.getAddress());
    }
    private static native void _setEngineState(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleGearboxState} [Value]
     */
    public PxVehicleGearboxState getGearboxState() {
        checkNotNull();
        return PxVehicleGearboxState.wrapPointer(_getGearboxState(address));
    }
    private static native long _getGearboxState(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleGearboxState} [Value]
     */
    public void setGearboxState(PxVehicleGearboxState value) {
        checkNotNull();
        _setGearboxState(address, value.getAddress());
    }
    private static native void _setGearboxState(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleClutchSlipState} [Value]
     */
    public PxVehicleClutchSlipState getClutchState() {
        checkNotNull();
        return PxVehicleClutchSlipState.wrapPointer(_getClutchState(address));
    }
    private static native long _getClutchState(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleClutchSlipState} [Value]
     */
    public void setClutchState(PxVehicleClutchSlipState value) {
        checkNotNull();
        _setClutchState(address, value.getAddress());
    }
    private static native void _setClutchState(long address, long value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
