package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.geometry.PxGeometry;
import physx.physics.PxFilterData;
import physx.physics.PxQueryFilterCallback;
import physx.physics.PxQueryFilterData;
import physx.physics.PxShapeFlags;

public class PhysXIntegrationParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PhysXIntegrationParams wrapPointer(long address) {
        return address != 0L ? new PhysXIntegrationParams(address) : null;
    }
    
    public static PhysXIntegrationParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PhysXIntegrationParams(long address) {
        super(address);
    }

    // Constructors

    public PhysXIntegrationParams() {
        address = _PhysXIntegrationParams();
    }
    private static native long _PhysXIntegrationParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehiclePhysXRoadGeometryQueryParams} [Value]
     */
    public PxVehiclePhysXRoadGeometryQueryParams getPhysxRoadGeometryQueryParams() {
        checkNotNull();
        return PxVehiclePhysXRoadGeometryQueryParams.wrapPointer(_getPhysxRoadGeometryQueryParams(address));
    }
    private static native long _getPhysxRoadGeometryQueryParams(long address);

    /**
     * @param value WebIDL type: {@link PxVehiclePhysXRoadGeometryQueryParams} [Value]
     */
    public void setPhysxRoadGeometryQueryParams(PxVehiclePhysXRoadGeometryQueryParams value) {
        checkNotNull();
        _setPhysxRoadGeometryQueryParams(address, value.getAddress());
    }
    private static native void _setPhysxRoadGeometryQueryParams(long address, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehiclePhysXMaterialFrictionParams} [Value]
     */
    public PxVehiclePhysXMaterialFrictionParams getPhysxMaterialFrictionParams(int index) {
        checkNotNull();
        return PxVehiclePhysXMaterialFrictionParams.wrapPointer(_getPhysxMaterialFrictionParams(address, index));
    }
    private static native long _getPhysxMaterialFrictionParams(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehiclePhysXMaterialFrictionParams} [Value]
     */
    public void setPhysxMaterialFrictionParams(int index, PxVehiclePhysXMaterialFrictionParams value) {
        checkNotNull();
        _setPhysxMaterialFrictionParams(address, index, value.getAddress());
    }
    private static native void _setPhysxMaterialFrictionParams(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehiclePhysXSuspensionLimitConstraintParams} [Value]
     */
    public PxVehiclePhysXSuspensionLimitConstraintParams getPhysxSuspensionLimitConstraintParams(int index) {
        checkNotNull();
        return PxVehiclePhysXSuspensionLimitConstraintParams.wrapPointer(_getPhysxSuspensionLimitConstraintParams(address, index));
    }
    private static native long _getPhysxSuspensionLimitConstraintParams(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehiclePhysXSuspensionLimitConstraintParams} [Value]
     */
    public void setPhysxSuspensionLimitConstraintParams(int index, PxVehiclePhysXSuspensionLimitConstraintParams value) {
        checkNotNull();
        _setPhysxSuspensionLimitConstraintParams(address, index, value.getAddress());
    }
    private static native void _setPhysxSuspensionLimitConstraintParams(long address, int index, long value);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getPhysxActorCMassLocalPose() {
        checkNotNull();
        return PxTransform.wrapPointer(_getPhysxActorCMassLocalPose(address));
    }
    private static native long _getPhysxActorCMassLocalPose(long address);

    /**
     * @param value WebIDL type: {@link PxTransform} [Value]
     */
    public void setPhysxActorCMassLocalPose(PxTransform value) {
        checkNotNull();
        _setPhysxActorCMassLocalPose(address, value.getAddress());
    }
    private static native void _setPhysxActorCMassLocalPose(long address, long value);

    /**
     * @return WebIDL type: {@link PxGeometry}
     */
    public PxGeometry getPhysxActorGeometry() {
        checkNotNull();
        return PxGeometry.wrapPointer(_getPhysxActorGeometry(address));
    }
    private static native long _getPhysxActorGeometry(long address);

    /**
     * @param value WebIDL type: {@link PxGeometry}
     */
    public void setPhysxActorGeometry(PxGeometry value) {
        checkNotNull();
        _setPhysxActorGeometry(address, value.getAddress());
    }
    private static native void _setPhysxActorGeometry(long address, long value);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getPhysxActorBoxShapeLocalPose() {
        checkNotNull();
        return PxTransform.wrapPointer(_getPhysxActorBoxShapeLocalPose(address));
    }
    private static native long _getPhysxActorBoxShapeLocalPose(long address);

    /**
     * @param value WebIDL type: {@link PxTransform} [Value]
     */
    public void setPhysxActorBoxShapeLocalPose(PxTransform value) {
        checkNotNull();
        _setPhysxActorBoxShapeLocalPose(address, value.getAddress());
    }
    private static native void _setPhysxActorBoxShapeLocalPose(long address, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getPhysxWheelShapeLocalPoses(int index) {
        checkNotNull();
        return PxTransform.wrapPointer(_getPhysxWheelShapeLocalPoses(address, index));
    }
    private static native long _getPhysxWheelShapeLocalPoses(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxTransform} [Value]
     */
    public void setPhysxWheelShapeLocalPoses(int index, PxTransform value) {
        checkNotNull();
        _setPhysxWheelShapeLocalPoses(address, index, value.getAddress());
    }
    private static native void _setPhysxWheelShapeLocalPoses(long address, int index, long value);

    /**
     * @return WebIDL type: {@link PxShapeFlags} [Value]
     */
    public PxShapeFlags getPhysxActorShapeFlags() {
        checkNotNull();
        return PxShapeFlags.wrapPointer(_getPhysxActorShapeFlags(address));
    }
    private static native long _getPhysxActorShapeFlags(long address);

    /**
     * @param value WebIDL type: {@link PxShapeFlags} [Value]
     */
    public void setPhysxActorShapeFlags(PxShapeFlags value) {
        checkNotNull();
        _setPhysxActorShapeFlags(address, value.getAddress());
    }
    private static native void _setPhysxActorShapeFlags(long address, long value);

    /**
     * @return WebIDL type: {@link PxFilterData} [Value]
     */
    public PxFilterData getPhysxActorSimulationFilterData() {
        checkNotNull();
        return PxFilterData.wrapPointer(_getPhysxActorSimulationFilterData(address));
    }
    private static native long _getPhysxActorSimulationFilterData(long address);

    /**
     * @param value WebIDL type: {@link PxFilterData} [Value]
     */
    public void setPhysxActorSimulationFilterData(PxFilterData value) {
        checkNotNull();
        _setPhysxActorSimulationFilterData(address, value.getAddress());
    }
    private static native void _setPhysxActorSimulationFilterData(long address, long value);

    /**
     * @return WebIDL type: {@link PxFilterData} [Value]
     */
    public PxFilterData getPhysxActorQueryFilterData() {
        checkNotNull();
        return PxFilterData.wrapPointer(_getPhysxActorQueryFilterData(address));
    }
    private static native long _getPhysxActorQueryFilterData(long address);

    /**
     * @param value WebIDL type: {@link PxFilterData} [Value]
     */
    public void setPhysxActorQueryFilterData(PxFilterData value) {
        checkNotNull();
        _setPhysxActorQueryFilterData(address, value.getAddress());
    }
    private static native void _setPhysxActorQueryFilterData(long address, long value);

    /**
     * @return WebIDL type: {@link PxShapeFlags} [Value]
     */
    public PxShapeFlags getPhysxActorWheelShapeFlags() {
        checkNotNull();
        return PxShapeFlags.wrapPointer(_getPhysxActorWheelShapeFlags(address));
    }
    private static native long _getPhysxActorWheelShapeFlags(long address);

    /**
     * @param value WebIDL type: {@link PxShapeFlags} [Value]
     */
    public void setPhysxActorWheelShapeFlags(PxShapeFlags value) {
        checkNotNull();
        _setPhysxActorWheelShapeFlags(address, value.getAddress());
    }
    private static native void _setPhysxActorWheelShapeFlags(long address, long value);

    /**
     * @return WebIDL type: {@link PxFilterData} [Value]
     */
    public PxFilterData getPhysxActorWheelSimulationFilterData() {
        checkNotNull();
        return PxFilterData.wrapPointer(_getPhysxActorWheelSimulationFilterData(address));
    }
    private static native long _getPhysxActorWheelSimulationFilterData(long address);

    /**
     * @param value WebIDL type: {@link PxFilterData} [Value]
     */
    public void setPhysxActorWheelSimulationFilterData(PxFilterData value) {
        checkNotNull();
        _setPhysxActorWheelSimulationFilterData(address, value.getAddress());
    }
    private static native void _setPhysxActorWheelSimulationFilterData(long address, long value);

    /**
     * @return WebIDL type: {@link PxFilterData} [Value]
     */
    public PxFilterData getPhysxActorWheelQueryFilterData() {
        checkNotNull();
        return PxFilterData.wrapPointer(_getPhysxActorWheelQueryFilterData(address));
    }
    private static native long _getPhysxActorWheelQueryFilterData(long address);

    /**
     * @param value WebIDL type: {@link PxFilterData} [Value]
     */
    public void setPhysxActorWheelQueryFilterData(PxFilterData value) {
        checkNotNull();
        _setPhysxActorWheelQueryFilterData(address, value.getAddress());
    }
    private static native void _setPhysxActorWheelQueryFilterData(long address, long value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PhysXIntegrationParams} [Value]
     */
    public PhysXIntegrationParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PhysXIntegrationParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @param axleDesc WebIDL type: {@link PxVehicleAxleDescription} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean isValid(PxVehicleAxleDescription axleDesc) {
        checkNotNull();
        return _isValid(address, axleDesc.getAddress());
    }
    private static native boolean _isValid(long address, long axleDesc);

    /**
     * @param axleDesc                    WebIDL type: {@link PxVehicleAxleDescription} [Const, Ref]
     * @param roadQueryFilterData         WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @param roadQueryFilterCallback     WebIDL type: {@link PxQueryFilterCallback} [Nullable]
     * @param materialFrictions           WebIDL type: {@link PxVehiclePhysXMaterialFriction}
     * @param nbMaterialFrictions         WebIDL type: unsigned long
     * @param defaultFriction             WebIDL type: float
     * @param physxActorCMassLocalPose    WebIDL type: {@link PxTransform} [Const, Ref]
     * @param actorGeometry               WebIDL type: {@link PxGeometry} [Ref]
     * @param physxActorBoxShapeLocalPose WebIDL type: {@link PxTransform} [Const, Ref]
     * @param roadGeometryQueryType       WebIDL type: {@link PxVehiclePhysXRoadGeometryQueryTypeEnum} [enum]
     */
    public void create(PxVehicleAxleDescription axleDesc, PxQueryFilterData roadQueryFilterData, PxQueryFilterCallback roadQueryFilterCallback, PxVehiclePhysXMaterialFriction materialFrictions, int nbMaterialFrictions, float defaultFriction, PxTransform physxActorCMassLocalPose, PxGeometry actorGeometry, PxTransform physxActorBoxShapeLocalPose, PxVehiclePhysXRoadGeometryQueryTypeEnum roadGeometryQueryType) {
        checkNotNull();
        _create(address, axleDesc.getAddress(), roadQueryFilterData.getAddress(), (roadQueryFilterCallback != null ? roadQueryFilterCallback.getAddress() : 0L), materialFrictions.getAddress(), nbMaterialFrictions, defaultFriction, physxActorCMassLocalPose.getAddress(), actorGeometry.getAddress(), physxActorBoxShapeLocalPose.getAddress(), roadGeometryQueryType.value);
    }
    private static native void _create(long address, long axleDesc, long roadQueryFilterData, long roadQueryFilterCallback, long materialFrictions, int nbMaterialFrictions, float defaultFriction, long physxActorCMassLocalPose, long actorGeometry, long physxActorBoxShapeLocalPose, int roadGeometryQueryType);

}
