package physx.vehicle2;

import physx.NativeObject;

/**
 * A description of the state of commands that are applied to the vehicle
 * <b>Note:</b> brakes[0] and brakes[1] may be used to distinguish brake and handbrake controls.
 */
public class PxVehicleCommandState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleCommandState wrapPointer(long address) {
        return address != 0L ? new PxVehicleCommandState(address) : null;
    }
    
    public static PxVehicleCommandState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleCommandState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleCommandState() {
        address = _PxVehicleCommandState();
    }
    private static native long _PxVehicleCommandState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getBrakes(int index) {
        checkNotNull();
        return _getBrakes(address, index);
    }
    private static native float _getBrakes(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setBrakes(int index, float value) {
        checkNotNull();
        _setBrakes(address, index, value);
    }
    private static native void _setBrakes(long address, int index, float value);

    /**
     */
    public int getNbBrakes() {
        checkNotNull();
        return _getNbBrakes(address);
    }
    private static native int _getNbBrakes(long address);

    /**
     */
    public void setNbBrakes(int value) {
        checkNotNull();
        _setNbBrakes(address, value);
    }
    private static native void _setNbBrakes(long address, int value);

    /**
     * The instantaneous state of the throttle controller in range [0,1] with 1 denoting fully pressed and 0 fully depressed.
     */
    public float getThrottle() {
        checkNotNull();
        return _getThrottle(address);
    }
    private static native float _getThrottle(long address);

    /**
     * The instantaneous state of the throttle controller in range [0,1] with 1 denoting fully pressed and 0 fully depressed.
     */
    public void setThrottle(float value) {
        checkNotNull();
        _setThrottle(address, value);
    }
    private static native void _setThrottle(long address, float value);

    /**
     * The instantaneous state of the steer controller in range [-1,1].
     */
    public float getSteer() {
        checkNotNull();
        return _getSteer(address);
    }
    private static native float _getSteer(long address);

    /**
     * The instantaneous state of the steer controller in range [-1,1].
     */
    public void setSteer(float value) {
        checkNotNull();
        _setSteer(address, value);
    }
    private static native void _setSteer(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
