package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleEngineParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleEngineParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleEngineParams(address) : null;
    }
    
    public static PxVehicleEngineParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleEngineParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleEngineParams
     */
    public static PxVehicleEngineParams createAt(long address) {
        __placement_new_PxVehicleEngineParams(address);
        PxVehicleEngineParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleEngineParams
     */
    public static <T> PxVehicleEngineParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleEngineParams(address);
        PxVehicleEngineParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleEngineParams(long address);

    // Constructors

    public PxVehicleEngineParams() {
        address = _PxVehicleEngineParams();
    }
    private static native long _PxVehicleEngineParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleTorqueCurveLookupTable} [Value]
     */
    public PxVehicleTorqueCurveLookupTable getTorqueCurve() {
        checkNotNull();
        return PxVehicleTorqueCurveLookupTable.wrapPointer(_getTorqueCurve(address));
    }
    private static native long _getTorqueCurve(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleTorqueCurveLookupTable} [Value]
     */
    public void setTorqueCurve(PxVehicleTorqueCurveLookupTable value) {
        checkNotNull();
        _setTorqueCurve(address, value.getAddress());
    }
    private static native void _setTorqueCurve(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getMoi() {
        checkNotNull();
        return _getMoi(address);
    }
    private static native float _getMoi(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMoi(float value) {
        checkNotNull();
        _setMoi(address, value);
    }
    private static native void _setMoi(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getPeakTorque() {
        checkNotNull();
        return _getPeakTorque(address);
    }
    private static native float _getPeakTorque(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setPeakTorque(float value) {
        checkNotNull();
        _setPeakTorque(address, value);
    }
    private static native void _setPeakTorque(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getIdleOmega() {
        checkNotNull();
        return _getIdleOmega(address);
    }
    private static native float _getIdleOmega(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setIdleOmega(float value) {
        checkNotNull();
        _setIdleOmega(address, value);
    }
    private static native void _setIdleOmega(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMaxOmega() {
        checkNotNull();
        return _getMaxOmega(address);
    }
    private static native float _getMaxOmega(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMaxOmega(float value) {
        checkNotNull();
        _setMaxOmega(address, value);
    }
    private static native void _setMaxOmega(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getDampingRateFullThrottle() {
        checkNotNull();
        return _getDampingRateFullThrottle(address);
    }
    private static native float _getDampingRateFullThrottle(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDampingRateFullThrottle(float value) {
        checkNotNull();
        _setDampingRateFullThrottle(address, value);
    }
    private static native void _setDampingRateFullThrottle(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getDampingRateZeroThrottleClutchEngaged() {
        checkNotNull();
        return _getDampingRateZeroThrottleClutchEngaged(address);
    }
    private static native float _getDampingRateZeroThrottleClutchEngaged(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDampingRateZeroThrottleClutchEngaged(float value) {
        checkNotNull();
        _setDampingRateZeroThrottleClutchEngaged(address, value);
    }
    private static native void _setDampingRateZeroThrottleClutchEngaged(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getDampingRateZeroThrottleClutchDisengaged() {
        checkNotNull();
        return _getDampingRateZeroThrottleClutchDisengaged(address);
    }
    private static native float _getDampingRateZeroThrottleClutchDisengaged(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setDampingRateZeroThrottleClutchDisengaged(float value) {
        checkNotNull();
        _setDampingRateZeroThrottleClutchDisengaged(address, value);
    }
    private static native void _setDampingRateZeroThrottleClutchDisengaged(long address, float value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleEngineParams} [Value]
     */
    public PxVehicleEngineParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleEngineParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
