package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleScale extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleScale wrapPointer(long address) {
        return address != 0L ? new PxVehicleScale(address) : null;
    }
    
    public static PxVehicleScale arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleScale(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleScale() {
        address = _PxVehicleScale();
    }
    private static native long _PxVehicleScale();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The length scale used for the vehicle. For example, if 1.0 is considered meters, then 100.0 would be for centimeters.
     */
    public float getScale() {
        checkNotNull();
        return _getScale(address);
    }
    private static native float _getScale(long address);

    /**
     * The length scale used for the vehicle. For example, if 1.0 is considered meters, then 100.0 would be for centimeters.
     */
    public void setScale(float value) {
        checkNotNull();
        _setScale(address, value);
    }
    private static native void _setScale(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
