package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.common.PxVec3;

public class PxVehicleSuspensionParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleSuspensionParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleSuspensionParams(address) : null;
    }
    
    public static PxVehicleSuspensionParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleSuspensionParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleSuspensionParams() {
        address = _PxVehicleSuspensionParams();
    }
    private static native long _PxVehicleSuspensionParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * suspensionAttachment specifies the wheel pose at maximum compression.
     * <b>Note:</b> suspensionAttachment is specified in the frame of the rigid body.
     * <b>Note:</b> camber, steer and toe angles are all applied in the suspension frame.
     */
    public PxTransform getSuspensionAttachment() {
        checkNotNull();
        return PxTransform.wrapPointer(_getSuspensionAttachment(address));
    }
    private static native long _getSuspensionAttachment(long address);

    /**
     * suspensionAttachment specifies the wheel pose at maximum compression.
     * <b>Note:</b> suspensionAttachment is specified in the frame of the rigid body.
     * <b>Note:</b> camber, steer and toe angles are all applied in the suspension frame.
     */
    public void setSuspensionAttachment(PxTransform value) {
        checkNotNull();
        _setSuspensionAttachment(address, value.getAddress());
    }
    private static native void _setSuspensionAttachment(long address, long value);

    /**
     * suspensionTravelDir specifies the direction of suspension travel.
     * <b>Note:</b> suspensionTravelDir is specified in the frame of the rigid body.
     */
    public PxVec3 getSuspensionTravelDir() {
        checkNotNull();
        return PxVec3.wrapPointer(_getSuspensionTravelDir(address));
    }
    private static native long _getSuspensionTravelDir(long address);

    /**
     * suspensionTravelDir specifies the direction of suspension travel.
     * <b>Note:</b> suspensionTravelDir is specified in the frame of the rigid body.
     */
    public void setSuspensionTravelDir(PxVec3 value) {
        checkNotNull();
        _setSuspensionTravelDir(address, value.getAddress());
    }
    private static native void _setSuspensionTravelDir(long address, long value);

    /**
     * suspensionTravelDist is the maximum distance that the suspenson can elongate along #suspensionTravelDir
     * from the pose specified by #suspensionAttachment.
     * <b>Note:</b> The position suspensionAttachment.p + #suspensionTravelDir*#suspensionTravelDist corresponds to the 
     * the suspension at maximum droop in the rigid body frame.
     */
    public float getSuspensionTravelDist() {
        checkNotNull();
        return _getSuspensionTravelDist(address);
    }
    private static native float _getSuspensionTravelDist(long address);

    /**
     * suspensionTravelDist is the maximum distance that the suspenson can elongate along #suspensionTravelDir
     * from the pose specified by #suspensionAttachment.
     * <b>Note:</b> The position suspensionAttachment.p + #suspensionTravelDir*#suspensionTravelDist corresponds to the 
     * the suspension at maximum droop in the rigid body frame.
     */
    public void setSuspensionTravelDist(float value) {
        checkNotNull();
        _setSuspensionTravelDist(address, value);
    }
    private static native void _setSuspensionTravelDist(long address, float value);

    /**
     * wheelAttachment is the pose of the wheel in the suspension frame.
     * <b>Note:</b> The rotation angle around the wheel's lateral axis is applied in the wheel attachment frame.
     */
    public PxTransform getWheelAttachment() {
        checkNotNull();
        return PxTransform.wrapPointer(_getWheelAttachment(address));
    }
    private static native long _getWheelAttachment(long address);

    /**
     * wheelAttachment is the pose of the wheel in the suspension frame.
     * <b>Note:</b> The rotation angle around the wheel's lateral axis is applied in the wheel attachment frame.
     */
    public void setWheelAttachment(PxTransform value) {
        checkNotNull();
        _setWheelAttachment(address, value.getAddress());
    }
    private static native void _setWheelAttachment(long address, long value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleSuspensionParams} [Value]
     */
    public PxVehicleSuspensionParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleSuspensionParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
