package physx.character;

/**
 * specifies which sides a character is colliding with.
 */
public enum PxControllerCollisionFlagEnum {

    /**
     * Character is colliding to the sides.
     */
    eCOLLISION_SIDES(geteCOLLISION_SIDES()),
    /**
     * Character has collision above.
     */
    eCOLLISION_UP(geteCOLLISION_UP()),
    eCOLLISION_DOWN(geteCOLLISION_DOWN());
    public final int value;
    
    PxControllerCollisionFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteCOLLISION_SIDES();
    private static int geteCOLLISION_SIDES() {
        de.fabmax.physxjni.Loader.load();
        return _geteCOLLISION_SIDES();
    }

    private static native int _geteCOLLISION_UP();
    private static int geteCOLLISION_UP() {
        de.fabmax.physxjni.Loader.load();
        return _geteCOLLISION_UP();
    }

    private static native int _geteCOLLISION_DOWN();
    private static int geteCOLLISION_DOWN() {
        de.fabmax.physxjni.Loader.load();
        return _geteCOLLISION_DOWN();
    }

    public static PxControllerCollisionFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxControllerCollisionFlagEnum: " + value);
    }

}
