package physx.character;

import physx.NativeObject;
import physx.common.PxVec3;

/**
 * Describes a generic CCT hit.
 */
public class PxControllerHit extends NativeObject {

    protected PxControllerHit() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxControllerHit wrapPointer(long address) {
        return address != 0L ? new PxControllerHit(address) : null;
    }
    
    public static PxControllerHit arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxControllerHit(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * Current controller
     */
    public PxController getController() {
        checkNotNull();
        return PxController.wrapPointer(_getController(address));
    }
    private static native long _getController(long address);

    /**
     * Current controller
     */
    public void setController(PxController value) {
        checkNotNull();
        _setController(address, value.getAddress());
    }
    private static native void _setController(long address, long value);

    /**
     * Contact position in world space
     */
    public PxExtendedVec3 getWorldPos() {
        checkNotNull();
        return PxExtendedVec3.wrapPointer(_getWorldPos(address));
    }
    private static native long _getWorldPos(long address);

    /**
     * Contact position in world space
     */
    public void setWorldPos(PxExtendedVec3 value) {
        checkNotNull();
        _setWorldPos(address, value.getAddress());
    }
    private static native void _setWorldPos(long address, long value);

    /**
     * Contact normal in world space
     */
    public PxVec3 getWorldNormal() {
        checkNotNull();
        return PxVec3.wrapPointer(_getWorldNormal(address));
    }
    private static native long _getWorldNormal(long address);

    /**
     * Contact normal in world space
     */
    public void setWorldNormal(PxVec3 value) {
        checkNotNull();
        _setWorldNormal(address, value.getAddress());
    }
    private static native void _setWorldNormal(long address, long value);

    /**
     * Motion direction
     */
    public PxVec3 getDir() {
        checkNotNull();
        return PxVec3.wrapPointer(_getDir(address));
    }
    private static native long _getDir(long address);

    /**
     * Motion direction
     */
    public void setDir(PxVec3 value) {
        checkNotNull();
        _setDir(address, value.getAddress());
    }
    private static native void _setDir(long address, long value);

    /**
     * Motion length
     */
    public float getLength() {
        checkNotNull();
        return _getLength(address);
    }
    private static native float _getLength(long address);

    /**
     * Motion length
     */
    public void setLength(float value) {
        checkNotNull();
        _setLength(address, value);
    }
    private static native void _setLength(long address, float value);

}
