package physx.geometry;

/**
 * Flags controlling the simulated behavior of the convex mesh geometry.
 * <p>
 * Used in ::PxConvexMeshGeometryFlags.
 */
public enum PxConvexMeshGeometryFlagEnum {

    eTIGHT_BOUNDS(geteTIGHT_BOUNDS());
    public final int value;
    
    PxConvexMeshGeometryFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteTIGHT_BOUNDS();
    private static int geteTIGHT_BOUNDS() {
        de.fabmax.physxjni.Loader.load();
        return _geteTIGHT_BOUNDS();
    }

    public static PxConvexMeshGeometryFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxConvexMeshGeometryFlagEnum: " + value);
    }

}
