package physx.geometry;

import physx.NativeObject;

/**
 * A geometry object.
 * <p>
 * A geometry object defines the characteristics of a spatial object, but without any information
 * about its placement in the world.
 * <p>
 * <b>Note:</b> This is an abstract class.  You cannot create instances directly.  Create an instance of one of the derived classes instead.
 */
public class PxGeometry extends NativeObject {

    protected PxGeometry() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxGeometry wrapPointer(long address) {
        return address != 0L ? new PxGeometry(address) : null;
    }
    
    public static PxGeometry arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxGeometry(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * Returns the type of the geometry.
     * @return The type of the object.
     */
    public PxGeometryTypeEnum getType() {
        checkNotNull();
        return PxGeometryTypeEnum.forValue(_getType(address));
    }
    private static native int _getType(long address);

}
