package physx.particles;

import physx.PlatformChecks;

/**
 * Material class to represent a set of PBD particle material properties.
 */
public class PxPBDMaterial extends PxParticleMaterial {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxPBDMaterial");
    }

    protected PxPBDMaterial() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxPBDMaterial wrapPointer(long address) {
        return address != 0L ? new PxPBDMaterial(address) : null;
    }
    
    public static PxPBDMaterial arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxPBDMaterial(long address) {
        super(address);
    }

    // Functions

    /**
     * Sets viscosity
     * @param viscosity Viscosity. <b>Range:</b> [0, PX_MAX_F32)
     */
    public void setViscosity(float viscosity) {
        checkNotNull();
        _setViscosity(address, viscosity);
    }
    private static native void _setViscosity(long address, float viscosity);

    /**
     * Retrieves the viscosity value.
     * @return The viscosity value.
     */
    public float getViscosity() {
        checkNotNull();
        return _getViscosity(address);
    }
    private static native float _getViscosity(long address);

    /**
     * Sets material vorticity confinement coefficient
     * @param vorticityConfinement Material vorticity confinement coefficient. <b>Range:</b> [0, PX_MAX_F32)
     */
    public void setVorticityConfinement(float vorticityConfinement) {
        checkNotNull();
        _setVorticityConfinement(address, vorticityConfinement);
    }
    private static native void _setVorticityConfinement(long address, float vorticityConfinement);

    /**
     * Retrieves the vorticity confinement coefficient.
     * @return The vorticity confinement coefficient.
     */
    public float getVorticityConfinement() {
        checkNotNull();
        return _getVorticityConfinement(address);
    }
    private static native float _getVorticityConfinement(long address);

    /**
     * Sets material surface tension coefficient
     * @param surfaceTension Material surface tension coefficient. <b>Range:</b> [0, PX_MAX_F32)
     */
    public void setSurfaceTension(float surfaceTension) {
        checkNotNull();
        _setSurfaceTension(address, surfaceTension);
    }
    private static native void _setSurfaceTension(long address, float surfaceTension);

    /**
     * Retrieves the surface tension coefficient.
     * @return The surface tension coefficient.
     */
    public float getSurfaceTension() {
        checkNotNull();
        return _getSurfaceTension(address);
    }
    private static native float _getSurfaceTension(long address);

    /**
     * Sets material cohesion coefficient
     * @param cohesion Material cohesion coefficient. <b>Range:</b> [0, PX_MAX_F32)
     */
    public void setCohesion(float cohesion) {
        checkNotNull();
        _setCohesion(address, cohesion);
    }
    private static native void _setCohesion(long address, float cohesion);

    /**
     * Retrieves the cohesion coefficient.
     * @return The cohesion coefficient.
     */
    public float getCohesion() {
        checkNotNull();
        return _getCohesion(address);
    }
    private static native float _getCohesion(long address);

    /**
     * Sets material lift coefficient
     * @param lift Material lift coefficient. <b>Range:</b> [0, PX_MAX_F32)
     */
    public void setLift(float lift) {
        checkNotNull();
        _setLift(address, lift);
    }
    private static native void _setLift(long address, float lift);

    /**
     * Retrieves the lift coefficient.
     * @return The lift coefficient.
     */
    public float getLift() {
        checkNotNull();
        return _getLift(address);
    }
    private static native float _getLift(long address);

    /**
     * Sets material drag coefficient
     * @param drag Material drag coefficient. <b>Range:</b> [0, PX_MAX_F32)
     */
    public void setDrag(float drag) {
        checkNotNull();
        _setDrag(address, drag);
    }
    private static native void _setDrag(long address, float drag);

    /**
     * Retrieves the drag coefficient.
     * @return The drag coefficient.
     */
    public float getDrag() {
        checkNotNull();
        return _getDrag(address);
    }
    private static native float _getDrag(long address);

    /**
     * Sets the CFL coefficient.
     * @param coefficient CFL coefficient. This coefficient scales the CFL term used to limit relative motion between fluid particles. <b>Range:</b> [1.f, PX_MAX_F32)
     */
    public void setCFLCoefficient(float coefficient) {
        checkNotNull();
        _setCFLCoefficient(address, coefficient);
    }
    private static native void _setCFLCoefficient(long address, float coefficient);

    /**
     * Retrieves the CFL coefficient.
     * @return The CFL coefficient.
     */
    public float getCFLCoefficient() {
        checkNotNull();
        return _getCFLCoefficient(address);
    }
    private static native float _getCFLCoefficient(long address);

    /**
     * Sets material particle friction scale. This allows the application to scale up/down the frictional effect between particles independent of the friction 
     * coefficient, which also defines frictional behavior between the particle and rigid bodies/soft bodies/cloth etc.
     * @param scale particle friction scale. <b>Range:</b> [0, PX_MAX_F32)
     */
    public void setParticleFrictionScale(float scale) {
        checkNotNull();
        _setParticleFrictionScale(address, scale);
    }
    private static native void _setParticleFrictionScale(long address, float scale);

    /**
     * Retrieves the particle friction scale.
     * @return The particle friction scale.
     */
    public float getParticleFrictionScale() {
        checkNotNull();
        return _getParticleFrictionScale(address);
    }
    private static native float _getParticleFrictionScale(long address);

    /**
     * Sets material particle adhesion scale value. This is the adhesive value between particles defined as a scaled multiple of the adhesion parameter.
     * @param adhesion particle adhesion scale value. <b>Range:</b> [0, PX_MAX_F32)
     */
    public void setParticleAdhesionScale(float adhesion) {
        checkNotNull();
        _setParticleAdhesionScale(address, adhesion);
    }
    private static native void _setParticleAdhesionScale(long address, float adhesion);

    /**
     * Retrieves the particle adhesion scale value.
     * @return The particle adhesion scale value.
     */
    public float getParticleAdhesionScale() {
        checkNotNull();
        return _getParticleAdhesionScale(address);
    }
    private static native float _getParticleAdhesionScale(long address);

    /**
     * @return WebIDL type: DOMString
     */
    public String getConcreteTypeName() {
        checkNotNull();
        return _getConcreteTypeName(address);
    }
    private static native String _getConcreteTypeName(long address);

}
