package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;

/**
 * @brief Preprocessor to prepare particle cloths for simulation.
 * <p>
 * Preprocessing is done by calling #PxParticleClothPreProcessor::partitionSprings() on an instance of this class. This will allocate the memory in the 
 * output object, partition the springs and fill all the members of the ouput object. The output can then be passed without 
 * any further modifications to #PxParticleClothBuffer::setCloths().
 * <p>
 * See #PxCreateParticleClothPreprocessor, #PxParticleClothDesc, #PxPartitionedParticleCloth
 */
public class PxParticleClothPreProcessor extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleClothPreProcessor");
    }

    protected PxParticleClothPreProcessor() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleClothPreProcessor wrapPointer(long address) {
        return address != 0L ? new PxParticleClothPreProcessor(address) : null;
    }
    
    public static PxParticleClothPreProcessor arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleClothPreProcessor(long address) {
        super(address);
    }

    // Functions

    /**
     * Release this object and deallocate all the memory.
     */
    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    /**
     * Partition the spring constraints for particle cloth simulation.
     * @param clothDesc Reference to a valid #PxParticleClothDesc.
     * @param output Reference to a #PxPartitionedParticleCloth object. This is the output of the preprocessing and should be passed to a #PxParticleClothBuffer.
     */
    public void partitionSprings(PxParticleClothDesc clothDesc, PxPartitionedParticleCloth output) {
        checkNotNull();
        _partitionSprings(address, clothDesc.getAddress(), output.getAddress());
    }
    private static native void _partitionSprings(long address, long clothDesc, long output);

}
