package physx.particles;

/**
 * Identifies the solver to use for a particle system.
 */
public enum PxParticleSolverTypeEnum {

    /**
     * The position based dynamics solver that can handle fluid, granular material, cloth, inflatables etc. See #PxPBDParticleSystem.
     */
    ePBD(getePBD()),
    /**
     * The FLIP fluid solver. See #PxFLIPParticleSystem.
     */
    eFLIP(geteFLIP()),
    eMPM(geteMPM());
    public final int value;
    
    PxParticleSolverTypeEnum(int value) {
        this.value = value;
    }

    private static native int _getePBD();
    private static int getePBD() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.particles.PxParticleSolverTypeEnum");
        return _getePBD();
    }

    private static native int _geteFLIP();
    private static int geteFLIP() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.particles.PxParticleSolverTypeEnum");
        return _geteFLIP();
    }

    private static native int _geteMPM();
    private static int geteMPM() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.particles.PxParticleSolverTypeEnum");
        return _geteMPM();
    }

    public static PxParticleSolverTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxParticleSolverTypeEnum: " + value);
    }

}
