package physx.physics;

public enum PxArticulationMotionEnum {

    /**
     * Locked axis, i.e. degree of freedom (DOF)
     */
    eLOCKED(geteLOCKED()),
    /**
     * Limited DOF - set limits of joint DOF together with this flag, see PxArticulationJointReducedCoordinate::setLimitParams
     */
    eLIMITED(geteLIMITED()),
    eFREE(geteFREE());
    public final int value;
    
    PxArticulationMotionEnum(int value) {
        this.value = value;
    }

    private static native int _geteLOCKED();
    private static int geteLOCKED() {
        de.fabmax.physxjni.Loader.load();
        return _geteLOCKED();
    }

    private static native int _geteLIMITED();
    private static int geteLIMITED() {
        de.fabmax.physxjni.Loader.load();
        return _geteLIMITED();
    }

    private static native int _geteFREE();
    private static int geteFREE() {
        de.fabmax.physxjni.Loader.load();
        return _geteFREE();
    }

    public static PxArticulationMotionEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationMotionEnum: " + value);
    }

}
