package physx.physics;

import physx.NativeObject;
import physx.common.PxBase;
import physx.common.PxTransform;

public class PxArticulationSensor extends PxBase {

    protected PxArticulationSensor() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationSensor wrapPointer(long address) {
        return address != 0L ? new PxArticulationSensor(address) : null;
    }
    
    public static PxArticulationSensor arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationSensor(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setUserData(NativeObject value) {
        checkNotNull();
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

    // Functions

    /**
     * @return WebIDL type: {@link PxSpatialForce} [Value]
     */
    public PxSpatialForce getForces() {
        checkNotNull();
        return PxSpatialForce.wrapPointer(_getForces(address));
    }
    private static native long _getForces(long address);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getRelativePose() {
        checkNotNull();
        return PxTransform.wrapPointer(_getRelativePose(address));
    }
    private static native long _getRelativePose(long address);

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setRelativePose(PxTransform pose) {
        checkNotNull();
        _setRelativePose(address, pose.getAddress());
    }
    private static native void _setRelativePose(long address, long pose);

    /**
     * @return WebIDL type: {@link PxArticulationLink}
     */
    public PxArticulationLink getLink() {
        checkNotNull();
        return PxArticulationLink.wrapPointer(_getLink(address));
    }
    private static native long _getLink(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getIndex() {
        checkNotNull();
        return _getIndex(address);
    }
    private static native int _getIndex(long address);

    /**
     * @return WebIDL type: {@link PxArticulationReducedCoordinate}
     */
    public PxArticulationReducedCoordinate getArticulation() {
        checkNotNull();
        return PxArticulationReducedCoordinate.wrapPointer(_getArticulation(address));
    }
    private static native long _getArticulation(long address);

    /**
     * @return WebIDL type: {@link PxArticulationSensorFlags} [Value]
     */
    public PxArticulationSensorFlags getFlags() {
        checkNotNull();
        return PxArticulationSensorFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param flag    WebIDL type: {@link PxArticulationSensorFlagEnum} [enum]
     * @param enabled WebIDL type: boolean
     */
    public void setFlag(PxArticulationSensorFlagEnum flag, boolean enabled) {
        checkNotNull();
        _setFlag(address, flag.value, enabled);
    }
    private static native void _setFlag(long address, int flag, boolean enabled);

}
