package physx.vehicle2;

import physx.NativeObject;

/**
 * Specifies the maximum clutch strength that occurs when the clutch pedal is fully disengaged and the clutch is fully engaged.
 */
public class PxVehicleClutchCommandResponseParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleClutchCommandResponseParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleClutchCommandResponseParams(address) : null;
    }
    
    public static PxVehicleClutchCommandResponseParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleClutchCommandResponseParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleClutchCommandResponseParams
     */
    public static PxVehicleClutchCommandResponseParams createAt(long address) {
        __placement_new_PxVehicleClutchCommandResponseParams(address);
        PxVehicleClutchCommandResponseParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleClutchCommandResponseParams
     */
    public static <T> PxVehicleClutchCommandResponseParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleClutchCommandResponseParams(address);
        PxVehicleClutchCommandResponseParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleClutchCommandResponseParams(long address);

    // Constructors

    public PxVehicleClutchCommandResponseParams() {
        address = _PxVehicleClutchCommandResponseParams();
    }
    private static native long _PxVehicleClutchCommandResponseParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * Strength of clutch.
     * <p>
     * <b>Note:</b> The clutch is the mechanism that couples the engine to the wheels.
     * A stronger clutch more strongly couples the engine to the wheels, while a
     * clutch of strength zero completely decouples the engine from the wheels.
     * Stronger clutches more quickly bring the wheels and engine into equilibrium, while weaker
     * clutches take longer, resulting in periods of clutch slip and delays in power transmission
     * from the engine to the wheels.
     * The torque generated by the clutch is proportional to the clutch strength and
     * the velocity difference between the engine's rotational speed and the rotational speed of the
     * driven wheels after accounting for the gear ratio.
     * The torque at the clutch is applied negatively to the engine and positively to the driven wheels.
     * <p>
     * <b>Range:</b> [0,inf)<br>
     * <b>Unit:</b> torque * time = mass * (length^2) / time
     */
    public float getMaxResponse() {
        checkNotNull();
        return _getMaxResponse(address);
    }
    private static native float _getMaxResponse(long address);

    /**
     * Strength of clutch.
     * <p>
     * <b>Note:</b> The clutch is the mechanism that couples the engine to the wheels.
     * A stronger clutch more strongly couples the engine to the wheels, while a
     * clutch of strength zero completely decouples the engine from the wheels.
     * Stronger clutches more quickly bring the wheels and engine into equilibrium, while weaker
     * clutches take longer, resulting in periods of clutch slip and delays in power transmission
     * from the engine to the wheels.
     * The torque generated by the clutch is proportional to the clutch strength and
     * the velocity difference between the engine's rotational speed and the rotational speed of the
     * driven wheels after accounting for the gear ratio.
     * The torque at the clutch is applied negatively to the engine and positively to the driven wheels.
     * <p>
     * <b>Range:</b> [0,inf)<br>
     * <b>Unit:</b> torque * time = mass * (length^2) / time
     */
    public void setMaxResponse(float value) {
        checkNotNull();
        _setMaxResponse(address, value);
    }
    private static native void _setMaxResponse(long address, float value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleClutchCommandResponseParams} [Value]
     */
    public PxVehicleClutchCommandResponseParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleClutchCommandResponseParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
