package physx.vehicle2;


/**
 * PxVehicleFourWheelDriveDifferentialParams specifies the wheels that are to receive drive torque from the differential 
 * and the division of torque between the wheels that are connected to the differential.  Additionally, it specifies the biases
 * and strength of a limited slip differential that operates on two wheels specified as front wheels and two wheels specified
 * as rear wheels.  
 */
public class PxVehicleFourWheelDriveDifferentialParams extends PxVehicleMultiWheelDriveDifferentialParams {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleFourWheelDriveDifferentialParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleFourWheelDriveDifferentialParams(address) : null;
    }
    
    public static PxVehicleFourWheelDriveDifferentialParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleFourWheelDriveDifferentialParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleFourWheelDriveDifferentialParams
     */
    public static PxVehicleFourWheelDriveDifferentialParams createAt(long address) {
        __placement_new_PxVehicleFourWheelDriveDifferentialParams(address);
        PxVehicleFourWheelDriveDifferentialParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleFourWheelDriveDifferentialParams
     */
    public static <T> PxVehicleFourWheelDriveDifferentialParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleFourWheelDriveDifferentialParams(address);
        PxVehicleFourWheelDriveDifferentialParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleFourWheelDriveDifferentialParams(long address);

    // Constructors

    public PxVehicleFourWheelDriveDifferentialParams() {
        address = _PxVehicleFourWheelDriveDifferentialParams();
    }
    private static native long _PxVehicleFourWheelDriveDifferentialParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getFrontWheelIds(int index) {
        checkNotNull();
        return _getFrontWheelIds(address, index);
    }
    private static native int _getFrontWheelIds(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setFrontWheelIds(int index, int value) {
        checkNotNull();
        _setFrontWheelIds(address, index, value);
    }
    private static native void _setFrontWheelIds(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getRearWheelIds(int index) {
        checkNotNull();
        return _getRearWheelIds(address, index);
    }
    private static native int _getRearWheelIds(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setRearWheelIds(int index, int value) {
        checkNotNull();
        _setRearWheelIds(address, index, value);
    }
    private static native void _setRearWheelIds(long address, int index, int value);

    /**
     * The parameter frontBias specifies the maximum angular speed ratio of the two front wheels specified by frontWheelIds[2].
     * <b>Note:</b> If frontBias has value 0.0, the differential will not try to enforce any relationship between the rotational speeds of the two front wheels.
     * <b>Note:</b> If frontBias has value 0.0, the torque split between the front wheels is specified by the array torqueRatios.
     * <b>Note:</b> frontBias must have value 0.0 (deactivated limited slip) or be greater than 1.0 (activated limited slip) or be equal to 1.0 (locked axle).
     * <b>Note:</b> If frontBias has value greater than or equal to 1.0 then the array frontWheelIds must be specified and the corresponding entries of 
     * the isConnected[] array must be set true.
     * <b>Note:</b> If frontBias has value greater than or equal to 1.0 then frontTarget must also be specified. 
     * <b>Note:</b> A locked axle may be achieved by setting frontBias and frontTarget to 1.0.
     * <b>Note:</b> A limited slip differential may be achieved by setting frontBias &gt; 1.0 and frontBias &gt; frontTarget &gt; 1.0. 
     */
    public float getFrontBias() {
        checkNotNull();
        return _getFrontBias(address);
    }
    private static native float _getFrontBias(long address);

    /**
     * The parameter frontBias specifies the maximum angular speed ratio of the two front wheels specified by frontWheelIds[2].
     * <b>Note:</b> If frontBias has value 0.0, the differential will not try to enforce any relationship between the rotational speeds of the two front wheels.
     * <b>Note:</b> If frontBias has value 0.0, the torque split between the front wheels is specified by the array torqueRatios.
     * <b>Note:</b> frontBias must have value 0.0 (deactivated limited slip) or be greater than 1.0 (activated limited slip) or be equal to 1.0 (locked axle).
     * <b>Note:</b> If frontBias has value greater than or equal to 1.0 then the array frontWheelIds must be specified and the corresponding entries of 
     * the isConnected[] array must be set true.
     * <b>Note:</b> If frontBias has value greater than or equal to 1.0 then frontTarget must also be specified. 
     * <b>Note:</b> A locked axle may be achieved by setting frontBias and frontTarget to 1.0.
     * <b>Note:</b> A limited slip differential may be achieved by setting frontBias &gt; 1.0 and frontBias &gt; frontTarget &gt; 1.0. 
     */
    public void setFrontBias(float value) {
        checkNotNull();
        _setFrontBias(address, value);
    }
    private static native void _setFrontBias(long address, float value);

    /**
     * The parameter frontTarget specifies the target rotational speed ratio of the two front wheels in the event that the ratio exceeds frontBias and frontBias
     * is configured for an activated limited slip or locked axle.
     * <b>Note:</b> frontTarget must be less than frontBias and greater than 1.0 to implement a limited slip differential.
     * <b>Note:</b> Set frontTarget and frontBias to 1.0 to implement a locked axle.
     */
    public float getFrontTarget() {
        checkNotNull();
        return _getFrontTarget(address);
    }
    private static native float _getFrontTarget(long address);

    /**
     * The parameter frontTarget specifies the target rotational speed ratio of the two front wheels in the event that the ratio exceeds frontBias and frontBias
     * is configured for an activated limited slip or locked axle.
     * <b>Note:</b> frontTarget must be less than frontBias and greater than 1.0 to implement a limited slip differential.
     * <b>Note:</b> Set frontTarget and frontBias to 1.0 to implement a locked axle.
     */
    public void setFrontTarget(float value) {
        checkNotNull();
        _setFrontTarget(address, value);
    }
    private static native void _setFrontTarget(long address, float value);

    /**
     * The parameter rearBias specifies the maximum angular speed ratio of the two rear wheels specified by rearWheelIds[2].
     * <b>Note:</b> If rearBias has value 0.0, the differential will not try to enforce any relationship between the rotational speeds of the two rear wheels.
     * <b>Note:</b> If rearBias has value 0.0, the torque split between the rear wheels is specified by the array torqueRatios.
     * <b>Note:</b> rearBias must have value 0.0 (deactivated limited slip) or be greater than 1.0 (activated limited slip) or be equal to 1.0 (locked axle).
     * <b>Note:</b> If rearBias has value greater than or equal to 1.0 then the array rearWheelIds must be specified and the corresponding entries of
     * the isConnected[] array must be set true.
     * <b>Note:</b> If rearBias has value greater than or equal to 1.0 then rearTarget must also be specified.  
     * <b>Note:</b> A locked axle may be achieved by setting rearBias and rearTarget to 1.0.
     * <b>Note:</b> A limited slip differential may be achieved by setting rearBias &gt; 1.0 and rearBias &gt; rearTarget &gt; 1.0
     */
    public float getRearBias() {
        checkNotNull();
        return _getRearBias(address);
    }
    private static native float _getRearBias(long address);

    /**
     * The parameter rearBias specifies the maximum angular speed ratio of the two rear wheels specified by rearWheelIds[2].
     * <b>Note:</b> If rearBias has value 0.0, the differential will not try to enforce any relationship between the rotational speeds of the two rear wheels.
     * <b>Note:</b> If rearBias has value 0.0, the torque split between the rear wheels is specified by the array torqueRatios.
     * <b>Note:</b> rearBias must have value 0.0 (deactivated limited slip) or be greater than 1.0 (activated limited slip) or be equal to 1.0 (locked axle).
     * <b>Note:</b> If rearBias has value greater than or equal to 1.0 then the array rearWheelIds must be specified and the corresponding entries of
     * the isConnected[] array must be set true.
     * <b>Note:</b> If rearBias has value greater than or equal to 1.0 then rearTarget must also be specified.  
     * <b>Note:</b> A locked axle may be achieved by setting rearBias and rearTarget to 1.0.
     * <b>Note:</b> A limited slip differential may be achieved by setting rearBias &gt; 1.0 and rearBias &gt; rearTarget &gt; 1.0
     */
    public void setRearBias(float value) {
        checkNotNull();
        _setRearBias(address, value);
    }
    private static native void _setRearBias(long address, float value);

    /**
     * The parameter rearTarget specifies the target rotational speed ratio of the two rear wheels in the event that the ratio exceeds rearBias and rearBias
     * is configured for an activated limited slip or locked axle.
     * <b>Note:</b> rearTarget must be less than rearBias and greater than 1.0 to implement a limited slip differential.
     * <b>Note:</b> Set rearTarget and rearBias to 1.0 to implement a locked axle.
     */
    public float getRearTarget() {
        checkNotNull();
        return _getRearTarget(address);
    }
    private static native float _getRearTarget(long address);

    /**
     * The parameter rearTarget specifies the target rotational speed ratio of the two rear wheels in the event that the ratio exceeds rearBias and rearBias
     * is configured for an activated limited slip or locked axle.
     * <b>Note:</b> rearTarget must be less than rearBias and greater than 1.0 to implement a limited slip differential.
     * <b>Note:</b> Set rearTarget and rearBias to 1.0 to implement a locked axle.
     */
    public void setRearTarget(float value) {
        checkNotNull();
        _setRearTarget(address, value);
    }
    private static native void _setRearTarget(long address, float value);

    /**
     * The parameter centerBias specifies the maximum angular speed ratio of the sum of the two front wheels and the sum of the two rear wheels,
     * as specified by frontWheelIds[2] and rearWheelIds[2].
     * <b>Note:</b> If centerBias has value 0.0, the differential will not try to enforce any relationship between the rotational speeds of the front and rear wheels.
     * <b>Note:</b> If centerBias has value 0.0, the torque split between the front and rear rear wheels is specified by the array torqueRatios.
     * <b>Note:</b> centerBias must have value 0.0 (deactivated limited slip) or be greater than 1.0 (activated limited slip) or be equal to 1.0 (locked).
     * <b>Note:</b> If centerBias has value greater than or equal to 1.0 then the arrays frontWheelIds and rearWheelIds must be specified and the corresponding entries of 
     * the isConnected[] array must be set true.
     * <b>Note:</b> If centerBias has value greater than or equal to 1.0 then centerTarget must also be specified.  
     * <b>Note:</b> A locked front/rear differential may be achieved by setting centerBias and centerTarget to 1.0.
     * <b>Note:</b> A limited slip differential may be achieved by setting centerBias &gt; 1.0 and centerBias &gt; centerTarget &gt; 1.0
     */
    public float getCenterBias() {
        checkNotNull();
        return _getCenterBias(address);
    }
    private static native float _getCenterBias(long address);

    /**
     * The parameter centerBias specifies the maximum angular speed ratio of the sum of the two front wheels and the sum of the two rear wheels,
     * as specified by frontWheelIds[2] and rearWheelIds[2].
     * <b>Note:</b> If centerBias has value 0.0, the differential will not try to enforce any relationship between the rotational speeds of the front and rear wheels.
     * <b>Note:</b> If centerBias has value 0.0, the torque split between the front and rear rear wheels is specified by the array torqueRatios.
     * <b>Note:</b> centerBias must have value 0.0 (deactivated limited slip) or be greater than 1.0 (activated limited slip) or be equal to 1.0 (locked).
     * <b>Note:</b> If centerBias has value greater than or equal to 1.0 then the arrays frontWheelIds and rearWheelIds must be specified and the corresponding entries of 
     * the isConnected[] array must be set true.
     * <b>Note:</b> If centerBias has value greater than or equal to 1.0 then centerTarget must also be specified.  
     * <b>Note:</b> A locked front/rear differential may be achieved by setting centerBias and centerTarget to 1.0.
     * <b>Note:</b> A limited slip differential may be achieved by setting centerBias &gt; 1.0 and centerBias &gt; centerTarget &gt; 1.0
     */
    public void setCenterBias(float value) {
        checkNotNull();
        _setCenterBias(address, value);
    }
    private static native void _setCenterBias(long address, float value);

    /**
     * The parameter centerTarget specifies the target rotational speed ratio of the sum of the two front wheels and the sum of the two rear wheels 
     * in the event that the ratio exceeds centerBias and centerBias is configured for an activated limited slip.
     * <b>Note:</b> centerTarget must be less than centerBias and greater than 1.0 to implement a limited slip differential.
     * <b>Note:</b> Set centerTarget and centerBias to 1.0 to implement a locked differential.
     */
    public float getCenterTarget() {
        checkNotNull();
        return _getCenterTarget(address);
    }
    private static native float _getCenterTarget(long address);

    /**
     * The parameter centerTarget specifies the target rotational speed ratio of the sum of the two front wheels and the sum of the two rear wheels 
     * in the event that the ratio exceeds centerBias and centerBias is configured for an activated limited slip.
     * <b>Note:</b> centerTarget must be less than centerBias and greater than 1.0 to implement a limited slip differential.
     * <b>Note:</b> Set centerTarget and centerBias to 1.0 to implement a locked differential.
     */
    public void setCenterTarget(float value) {
        checkNotNull();
        _setCenterTarget(address, value);
    }
    private static native void _setCenterTarget(long address, float value);

    /**
     * The parameter rate specifies how quickly the ratio of rotational speeds approaches the target rotational speed ratio.
     * <b>Note:</b> strength must be in range [0,PX_VEHICLE_FOUR_WHEEL_DIFF_MAXIMUM_STRENGTH]. 
     * <b>Note:</b> The ratio of rotational speeds is decremented each update by rate*dt until the ratio is equal to the target ratio.
     * <b>Note:</b> A value of 0 will result in a deactivated limited slip.
     * <b>Note:</b> A value of PX_VEHICLE_FOUR_WHEEL_DIFF_MAXIMUM_STRENGTH will result in instantaneous correction of the rotational speed ratios.
     */
    public float getRate() {
        checkNotNull();
        return _getRate(address);
    }
    private static native float _getRate(long address);

    /**
     * The parameter rate specifies how quickly the ratio of rotational speeds approaches the target rotational speed ratio.
     * <b>Note:</b> strength must be in range [0,PX_VEHICLE_FOUR_WHEEL_DIFF_MAXIMUM_STRENGTH]. 
     * <b>Note:</b> The ratio of rotational speeds is decremented each update by rate*dt until the ratio is equal to the target ratio.
     * <b>Note:</b> A value of 0 will result in a deactivated limited slip.
     * <b>Note:</b> A value of PX_VEHICLE_FOUR_WHEEL_DIFF_MAXIMUM_STRENGTH will result in instantaneous correction of the rotational speed ratios.
     */
    public void setRate(float value) {
        checkNotNull();
        _setRate(address, value);
    }
    private static native void _setRate(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleFourWheelDriveDifferentialParams} [Value]
     */
    public PxVehicleFourWheelDriveDifferentialParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleFourWheelDriveDifferentialParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

}
