package physx.vehicle2;

/**
 * Determine whether the PhysX actor associated with a vehicle is to be updated with a velocity change or an acceleration change.
 * A velocity change will be immediately reflected in linear and angular velocity queries against the vehicle.  An acceleration change, on the other hand,
 * will leave the linear and angular velocities unchanged until the next PhysX scene update has applied the acceleration update to the actor's linear and
 * angular velocities.
 * <b>See also:</b> PxVehiclePhysXActorEndComponent
 * <b>See also:</b> PxVehicleWriteRigidBodyStateToPhysXActor
 */
public enum PxVehiclePhysXActorUpdateModeEnum {

    eAPPLY_VELOCITY(geteAPPLY_VELOCITY()),
    eAPPLY_ACCELERATION(geteAPPLY_ACCELERATION());
    public final int value;
    
    PxVehiclePhysXActorUpdateModeEnum(int value) {
        this.value = value;
    }

    private static native int _geteAPPLY_VELOCITY();
    private static int geteAPPLY_VELOCITY() {
        de.fabmax.physxjni.Loader.load();
        return _geteAPPLY_VELOCITY();
    }

    private static native int _geteAPPLY_ACCELERATION();
    private static int geteAPPLY_ACCELERATION() {
        de.fabmax.physxjni.Loader.load();
        return _geteAPPLY_ACCELERATION();
    }

    public static PxVehiclePhysXActorUpdateModeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxVehiclePhysXActorUpdateModeEnum: " + value);
    }

}
