package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxVehicleSimulationContext extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleSimulationContext wrapPointer(long address) {
        return address != 0L ? new PxVehicleSimulationContext(address) : null;
    }
    
    public static PxVehicleSimulationContext arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleSimulationContext(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleSimulationContext() {
        address = _PxVehicleSimulationContext();
    }
    private static native long _PxVehicleSimulationContext();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     */
    public PxVec3 getGravity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getGravity(address));
    }
    private static native long _getGravity(long address);

    /**
     */
    public void setGravity(PxVec3 value) {
        checkNotNull();
        _setGravity(address, value.getAddress());
    }
    private static native void _setGravity(long address, long value);

    /**
     */
    public PxVehicleFrame getFrame() {
        checkNotNull();
        return PxVehicleFrame.wrapPointer(_getFrame(address));
    }
    private static native long _getFrame(long address);

    /**
     */
    public void setFrame(PxVehicleFrame value) {
        checkNotNull();
        _setFrame(address, value.getAddress());
    }
    private static native void _setFrame(long address, long value);

    /**
     */
    public PxVehicleScale getScale() {
        checkNotNull();
        return PxVehicleScale.wrapPointer(_getScale(address));
    }
    private static native long _getScale(long address);

    /**
     */
    public void setScale(PxVehicleScale value) {
        checkNotNull();
        _setScale(address, value.getAddress());
    }
    private static native void _setScale(long address, long value);

    /**
     */
    public PxVehicleTireSlipParams getTireSlipParams() {
        checkNotNull();
        return PxVehicleTireSlipParams.wrapPointer(_getTireSlipParams(address));
    }
    private static native long _getTireSlipParams(long address);

    /**
     */
    public void setTireSlipParams(PxVehicleTireSlipParams value) {
        checkNotNull();
        _setTireSlipParams(address, value.getAddress());
    }
    private static native void _setTireSlipParams(long address, long value);

    /**
     */
    public PxVehicleTireStickyParams getTireStickyParams() {
        checkNotNull();
        return PxVehicleTireStickyParams.wrapPointer(_getTireStickyParams(address));
    }
    private static native long _getTireStickyParams(long address);

    /**
     */
    public void setTireStickyParams(PxVehicleTireStickyParams value) {
        checkNotNull();
        _setTireStickyParams(address, value.getAddress());
    }
    private static native void _setTireStickyParams(long address, long value);

    /**
     * Forward wheel speed below which the wheel rotation speed gets blended with the rolling speed.
     * <p>
     * The blended rotation speed is used to integrate the wheel rotation angle. At low forward wheel speed, 
     * the wheel rotation speed can get unstable (depending on the tire model used) and, for example, oscillate.
     * <p>
     * <b>Note:</b> If brake or throttle is applied, there will be no blending.
     * <p>
     * <b>Unit:</b> velocity = length / time
     */
    public float getThresholdForwardSpeedForWheelAngleIntegration() {
        checkNotNull();
        return _getThresholdForwardSpeedForWheelAngleIntegration(address);
    }
    private static native float _getThresholdForwardSpeedForWheelAngleIntegration(long address);

    /**
     * Forward wheel speed below which the wheel rotation speed gets blended with the rolling speed.
     * <p>
     * The blended rotation speed is used to integrate the wheel rotation angle. At low forward wheel speed, 
     * the wheel rotation speed can get unstable (depending on the tire model used) and, for example, oscillate.
     * <p>
     * <b>Note:</b> If brake or throttle is applied, there will be no blending.
     * <p>
     * <b>Unit:</b> velocity = length / time
     */
    public void setThresholdForwardSpeedForWheelAngleIntegration(float value) {
        checkNotNull();
        _setThresholdForwardSpeedForWheelAngleIntegration(address, value);
    }
    private static native void _setThresholdForwardSpeedForWheelAngleIntegration(long address, float value);

    /**
     * Structure to support Omni PVD, the PhysX Visual Debugger.
     */
    public PxVehiclePvdContext getPvdContext() {
        checkNotNull();
        return PxVehiclePvdContext.wrapPointer(_getPvdContext(address));
    }
    private static native long _getPvdContext(long address);

    /**
     * Structure to support Omni PVD, the PhysX Visual Debugger.
     */
    public void setPvdContext(PxVehiclePvdContext value) {
        checkNotNull();
        _setPvdContext(address, value.getAddress());
    }
    private static native void _setPvdContext(long address, long value);

    // Functions

    /**
     * @return WebIDL type: {@link PxVehicleSimulationContextTypeEnum} [enum]
     */
    public PxVehicleSimulationContextTypeEnum getType() {
        checkNotNull();
        return PxVehicleSimulationContextTypeEnum.forValue(_getType(address));
    }
    private static native int _getType(long address);

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleSimulationContext} [Value]
     */
    public PxVehicleSimulationContext transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleSimulationContext.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

}
