package physx.character;


public class PxBoxController extends PxController {

    protected PxBoxController() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBoxController wrapPointer(long address) {
        return address != 0L ? new PxBoxController(address) : null;
    }
    
    public static PxBoxController arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBoxController(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: float
     */
    public float getHalfHeight() {
        checkNotNull();
        return _getHalfHeight(address);
    }
    private static native float _getHalfHeight(long address);

    /**
     * @return WebIDL type: float
     */
    public float getHalfSideExtent() {
        checkNotNull();
        return _getHalfSideExtent(address);
    }
    private static native float _getHalfSideExtent(long address);

    /**
     * @return WebIDL type: float
     */
    public float getHalfForwardExtent() {
        checkNotNull();
        return _getHalfForwardExtent(address);
    }
    private static native float _getHalfForwardExtent(long address);

    /**
     * @param halfHeight WebIDL type: float
     * @return WebIDL type: boolean
     */
    public boolean setHalfHeight(float halfHeight) {
        checkNotNull();
        return _setHalfHeight(address, halfHeight);
    }
    private static native boolean _setHalfHeight(long address, float halfHeight);

    /**
     * @param halfSideExtent WebIDL type: float
     * @return WebIDL type: boolean
     */
    public boolean setHalfSideExtent(float halfSideExtent) {
        checkNotNull();
        return _setHalfSideExtent(address, halfSideExtent);
    }
    private static native boolean _setHalfSideExtent(long address, float halfSideExtent);

    /**
     * @param halfForwardExtent WebIDL type: float
     * @return WebIDL type: boolean
     */
    public boolean setHalfForwardExtent(float halfForwardExtent) {
        checkNotNull();
        return _setHalfForwardExtent(address, halfForwardExtent);
    }
    private static native boolean _setHalfForwardExtent(long address, float halfForwardExtent);

}
