package physx.character;

import physx.common.PxVec3;

public class PxBoxObstacle extends PxObstacle {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBoxObstacle wrapPointer(long address) {
        return address != 0L ? new PxBoxObstacle(address) : null;
    }
    
    public static PxBoxObstacle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBoxObstacle(long address) {
        super(address);
    }

    // Constructors

    public PxBoxObstacle() {
        address = _PxBoxObstacle();
    }
    private static native long _PxBoxObstacle();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getMHalfExtents() {
        checkNotNull();
        return PxVec3.wrapPointer(_getMHalfExtents(address));
    }
    private static native long _getMHalfExtents(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setMHalfExtents(PxVec3 value) {
        checkNotNull();
        _setMHalfExtents(address, value.getAddress());
    }
    private static native void _setMHalfExtents(long address, long value);

}
